/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.shelf;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.shelf.UIShelfItem;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIShelfGroup
extends SelfRenderingComponent {
    private String label = null;
    private boolean expanded = false;

    public String getFamily() {
        return "org.alfresco.faces.Shelf";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.expanded = (Boolean)values[1];
        this.label = (String)values[2];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.expanded ? Boolean.TRUE : Boolean.FALSE, this.label};
        return values;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.write("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">");
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UIShelfItem)) continue;
            out.write("<tr><td>");
            Utils.encodeRecursive(context, child);
            out.write("</td></tr>");
        }
        out.write("</table>");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String getLabel() {
        ValueBinding vb = this.getValueBinding("label");
        if (vb != null) {
            this.label = (String)vb.getValue(this.getFacesContext());
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isExpanded() {
        Boolean expanded;
        ValueBinding vb = this.getValueBinding("expanded");
        if (vb != null && (expanded = (Boolean)vb.getValue(this.getFacesContext())) != null) {
            this.expanded = expanded;
        }
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }
}

