/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.renderer.BaseRenderer;
import org.alfresco.web.ui.repo.component.UINodeDescendants;

public class NodeDescendantsLinkRenderer
extends BaseRenderer {
    private static final String DEFAULT_SEPARATOR = " | ";

    public void decode(FacesContext context, UIComponent component) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = NodeDescendantsLinkRenderer.getHiddenFieldName(context, component));
        if (value != null && value.startsWith(component.getClientId(context) + ':')) {
            value = value.substring(component.getClientId(context).length() + 1);
            int separatorIndex = value.indexOf(58);
            String selectedNodeId = value.substring(0, separatorIndex);
            boolean isParent = Boolean.parseBoolean(value.substring(separatorIndex + 1));
            NodeRef ref = new NodeRef(Repository.getStoreRef(), selectedNodeId);
            UINodeDescendants.NodeSelectedEvent event = new UINodeDescendants.NodeSelectedEvent(component, ref, isParent);
            component.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            ResponseWriter out = context.getResponseWriter();
            UINodeDescendants control = (UINodeDescendants)component;
            Object val = control.getValue();
            if (!(val instanceof NodeRef)) {
                throw new IllegalArgumentException("UINodeDescendants component 'value' property must resolve to a NodeRef!");
            }
            NodeRef parentRef = (NodeRef)val;
            NodeService service = NodeDescendantsLinkRenderer.getNodeService(context);
            DictionaryService dd = NodeDescendantsLinkRenderer.getDictionaryService(context);
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
                tx.begin();
                String separator = (String)component.getAttributes().get("separator");
                if (separator == null) {
                    separator = DEFAULT_SEPARATOR;
                }
                if (service.exists(parentRef)) {
                    List childRefs = service.getChildAssocs(parentRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                    ArrayList<ChildAssociationRef> refs = new ArrayList<ChildAssociationRef>(childRefs.size());
                    for (int index = 0; index < childRefs.size(); ++index) {
                        ChildAssociationRef ref = (ChildAssociationRef)childRefs.get(index);
                        QName type = service.getType(ref.getChildRef());
                        TypeDefinition typeDef = dd.getType(type);
                        if (typeDef == null || !dd.isSubClass(type, ContentModel.TYPE_FOLDER) || dd.isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER)) continue;
                        refs.add(ref);
                    }
                    int total = 0;
                    int maximum = refs.size() > control.getMaxChildren() ? control.getMaxChildren() : refs.size();
                    for (int index = 0; index < maximum; ++index) {
                        ChildAssociationRef ref = (ChildAssociationRef)refs.get(index);
                        QName type = service.getType(ref.getChildRef());
                        TypeDefinition typeDef = dd.getType(type);
                        if (typeDef == null || !dd.isSubClass(type, ContentModel.TYPE_FOLDER) || dd.isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER)) continue;
                        if (total > 0) {
                            out.write(separator);
                        }
                        out.write(this.renderDescendant(context, control, ref, false));
                        ++total;
                    }
                    if (control.getShowEllipses() && refs.size() > maximum) {
                        out.write(separator);
                        out.write(this.renderDescendant(context, control, service.getPrimaryParent(parentRef), true));
                    }
                }
                tx.commit();
            }
            catch (Throwable err) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
                throw new RuntimeException(err);
            }
        }
    }

    private String renderDescendant(FacesContext context, UINodeDescendants control, ChildAssociationRef childRef, boolean ellipses) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("<a href='#' onclick=\"");
        String param = control.getClientId(context) + ':' + childRef.getChildRef().getId() + ':' + Boolean.toString(ellipses);
        buf.append(Utils.generateFormSubmit(context, (UIComponent)control, NodeDescendantsLinkRenderer.getHiddenFieldName(context, (UIComponent)control), param));
        buf.append('\"');
        Map attrs = control.getAttributes();
        if (attrs.get("style") != null) {
            buf.append(" style=\"").append(attrs.get("style")).append('\"');
        }
        if (attrs.get("styleClass") != null) {
            buf.append(" class=").append(attrs.get("styleClass"));
        }
        buf.append('>');
        if (!ellipses) {
            String name = Repository.getNameForNode(NodeDescendantsLinkRenderer.getNodeService(context), childRef.getChildRef());
            buf.append(Utils.encode((String)name));
        } else {
            buf.append("...");
        }
        buf.append("</a>");
        return buf.toString();
    }

    private static String getHiddenFieldName(FacesContext context, UIComponent component) {
        return Utils.getParentForm(context, component).getClientId(context) + ':' + "ndec";
    }

    private static NodeService getNodeService(FacesContext context) {
        NodeService service = Repository.getServiceRegistry(context).getNodeService();
        if (service == null) {
            throw new IllegalStateException("Unable to obtain NodeService bean reference.");
        }
        return service;
    }

    private static DictionaryService getDictionaryService(FacesContext context) {
        DictionaryService service = Repository.getServiceRegistry(context).getDictionaryService();
        if (service == null) {
            throw new IllegalStateException("Unable to obtain DictionaryService bean reference.");
        }
        return service;
    }
}

