/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.renderer.BaseRenderer;
import org.alfresco.web.ui.repo.component.UITree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class YahooTreeRenderer
extends BaseRenderer {
    protected int nodeCounter;
    protected static final String TREE_SCRIPTS_WRITTEN = "_alfTreeScripts";
    private static final Log logger = LogFactory.getLog(YahooTreeRenderer.class);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UITree tree = (UITree)component;
        List<UITree.TreeNode> rootNodes = tree.getRootNodes();
        if (rootNodes != null && rootNodes.size() > 0) {
            ResponseWriter out = context.getResponseWriter();
            String treeContainerId = component.getClientId(context) + "Container";
            Object present = context.getExternalContext().getRequestMap().get(TREE_SCRIPTS_WRITTEN);
            if (present == null) {
                String reqPath = context.getExternalContext().getRequestContextPath();
                out.write("<link rel=\"stylesheet\" href=\"");
                out.write(reqPath);
                out.write("/css/yahoo-tree.css\" type=\"text/css\">");
                out.write("<script type=\"text/javascript\" src=\"");
                out.write(reqPath);
                out.write("/scripts/ajax/yahoo/treeview/treeview-min.js\"></script>");
                out.write("<script type=\"text/javascript\" src=\"");
                out.write(reqPath);
                out.write("/scripts/ajax/yahoo-tree.js\"></script>");
                context.getExternalContext().getRequestMap().put(TREE_SCRIPTS_WRITTEN, Boolean.TRUE);
            }
            out.write("<div id=\"");
            out.write(treeContainerId);
            out.write("\"></div>\n");
            out.write("<script type=\"text/javascript\">\n");
            out.write("var tree;\n");
            if (tree.getRetrieveChildrenUrl() != null) {
                out.write("setLoadDataUrl('");
                out.write(tree.getRetrieveChildrenUrl());
                out.write("');\n");
            }
            if (tree.getNodeCollapsedUrl() != null) {
                out.write("setCollapseUrl('");
                out.write(tree.getNodeCollapsedUrl());
                out.write("');\n");
            }
            if (tree.getNodeSelectedCallback() != null) {
                out.write("setNodeSelectedHandler('");
                out.write(tree.getNodeSelectedCallback());
                out.write("');\n");
            }
            out.write("function initTree() {\n");
            out.write("      tree = new YAHOO.widget.TreeView(\"");
            out.write(treeContainerId);
            out.write("\");\n");
            out.write("      var root = tree.getRoot();\n");
            if (tree.getNodeExpandedCallback() != null) {
                out.write("      tree.subscribe('expand', ");
                out.write(tree.getNodeExpandedCallback());
                out.write(");\n");
            }
            if (tree.getNodeCollapsedCallback() != null) {
                out.write("      tree.subscribe('collapse', ");
                out.write(tree.getNodeCollapsedCallback());
                out.write(");\n");
            }
            this.nodeCounter = 0;
            for (UITree.TreeNode node : rootNodes) {
                this.generateNode(node, out, null);
            }
            out.write("      tree.draw();\n");
            out.write("      tree.setDynamicLoad(loadDataForNode);\n}\n");
            out.write("YAHOO.util.Event.on(window, \"load\", window.initTree);");
            out.write("</script>\n");
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"There weren't any nodes to render");
        }
    }

    protected void generateNode(UITree.TreeNode node, ResponseWriter out, String parentVarName) throws IOException {
        String currentVarName = this.getNextVarName();
        out.write("      var ");
        out.write(currentVarName);
        out.write(" = createYahooTreeNode(");
        if (node.getParent() == null) {
            out.write("root");
        } else {
            out.write(parentVarName);
        }
        out.write(", \"");
        out.write(node.getNodeRef());
        out.write("\", \"");
        out.write(node.getName());
        out.write("\", \"");
        out.write(node.getIcon());
        out.write("\", ");
        out.write(Boolean.toString(node.isExpanded()));
        out.write(", ");
        out.write(Boolean.toString(node.isSelected()));
        out.write(");\n");
        if (node.isExpanded() && node.getChildren().size() > 0) {
            List<UITree.TreeNode> children = node.getChildren();
            if (children.size() > 1) {
                QuickSort sorter = new QuickSort(children, "name", true, "case-insensitive");
                sorter.sort();
            }
            for (UITree.TreeNode child : children) {
                this.generateNode(child, out, currentVarName);
            }
        }
    }

    protected String getNextVarName() {
        ++this.nodeCounter;
        return "n" + Integer.toString(this.nodeCounter);
    }
}

