/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.tag;

import java.io.IOException;
import java.io.Writer;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.coci.CCProperties;
import org.alfresco.web.config.ClientConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageTag
extends TagSupport {
    private static final long serialVersionUID = 8142765393181557228L;
    private static final String SCRIPTS_START = "<script type=\"text/javascript\" src=\"";
    private static final String SCRIPTS_END = "\"></script>\n";
    private static final String STYLES_START = "<link rel=\"stylesheet\" href=\"";
    private static final String STYLES_MAIN = "\" type=\"text/css\">\n";
    private static final String[] SCRIPTS = new String[]{"/scripts/menu.js", "/scripts/webdav.js", "/scripts/ajax/yahoo/yahoo/yahoo-min.js", "/scripts/ajax/yahoo/connection/connection-min.js", "/scripts/ajax/yahoo/event/event-min.js", "/scripts/ajax/mootools.v1.11.js", "/scripts/ajax/common.js", "/scripts/ajax/summary-info.js", "/scripts/ajax/picker.js", "/scripts/ajax/tagger.js"};
    private static final String[] CSS = new String[]{"/css/main.css", "/css/picker.css"};
    private static final String ALF_LOGO_HTTP = "http://www.alfresco.com/assets/images/logos/community-3.4.png";
    private static final String ALF_LOGO_HTTPS = "https://www.alfresco.com/assets/images/logos/community-3.4.png";
    private static final String ALF_URL = "http://www.alfresco.com";
    private static final String ALF_TEXT = "Alfresco Community";
    private static final String ALF_COPY = "Supplied free of charge with <a class='footer' href='http://www.alfresco.com/services/support/communityterms/#support'>no support</a>, <a class='footer' href='http://www.alfresco.com/services/support/communityterms/#certification'>no certification</a>, <a class='footer' href='http://www.alfresco.com/services/support/communityterms/#maintenance'>no maintenance</a>, <a class='footer' href='http://www.alfresco.com/services/support/communityterms/#warranty'>no warranty</a> and <a class='footer' href='http://www.alfresco.com/services/support/communityterms/#indemnity'>no indemnity</a> by <a class='footer' href='http://www.alfresco.com'>Alfresco</a> or its <a class='footer' href='http://www.alfresco.com/partners/'>Certified Partners</a>. <a class='footer' href='http://www.alfresco.com/services/support/'>Click here for support</a>. Alfresco Software Inc. &copy; 2005-2010 All rights reserved.";
    private static final Log logger = LogFactory.getLog(PageTag.class);
    private static String alfresco = null;
    private static String loginPage = null;
    private long startTime = 0L;
    private String title;
    private String titleId;
    private String doctypeRootElement;
    private String doctypePublic;
    private String doctypeSystem;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleId() {
        return this.titleId;
    }

    public void setTitleId(String titleId) {
        this.titleId = titleId;
    }

    public String getDoctypeRootElement() {
        return this.doctypeRootElement;
    }

    public void setDoctypeRootElement(String doctypeRootElement) {
        this.doctypeRootElement = doctypeRootElement;
    }

    public String getDoctypePublic() {
        return this.doctypePublic;
    }

    public void setDoctypePublic(String doctypePublic) {
        this.doctypePublic = doctypePublic;
    }

    public String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public void setDoctypeSystem(String doctypeSystem) {
        this.doctypeSystem = doctypeSystem;
    }

    public void release() {
        super.release();
        this.title = null;
        this.titleId = null;
        this.doctypeRootElement = null;
        this.doctypeSystem = null;
        this.doctypePublic = null;
    }

    public int doStartTag() throws JspException {
        if (logger.isDebugEnabled()) {
            this.startTime = System.currentTimeMillis();
        }
        try {
            String reqPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
            JspWriter out = this.pageContext.getOut();
            if (!Application.inPortalServer()) {
                if (this.getDoctypeRootElement() != null && this.getDoctypePublic() != null) {
                    out.write("<!DOCTYPE ");
                    out.write(this.getDoctypeRootElement().toLowerCase());
                    out.write(" PUBLIC \"" + this.getDoctypePublic() + "\"");
                    if (this.getDoctypeSystem() != null) {
                        out.write(" \"" + this.getDoctypeSystem() + "\"");
                    }
                    out.write(">\n");
                } else {
                    out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n");
                    out.write("    \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                }
                out.write("<html><head>");
                out.write("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=EmulateIE7\" />\n");
                out.write("<title>");
                if (this.titleId != null && this.titleId.length() != 0) {
                    out.write(Utils.encode((String)Application.getMessage(this.pageContext.getSession(), this.titleId)));
                } else if (this.title != null && this.title.length() != 0) {
                    out.write(Utils.encode((String)this.title));
                } else {
                    out.write("Alfresco Web Client");
                }
                out.write("</title>\n");
                out.write("<link rel=\"search\" type=\"application/opensearchdescription+xml\" href=\"" + reqPath + "/wcservice/api/search/keyword/description.xml\" title=\"Alfresco Keyword Search\">\n");
                out.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
            }
            for (String css : CSS) {
                out.write(STYLES_START);
                out.write(reqPath);
                out.write(css);
                out.write(STYLES_MAIN);
            }
            for (String s : SCRIPTS) {
                out.write(SCRIPTS_START);
                out.write(reqPath);
                out.write(s);
                out.write(SCRIPTS_END);
            }
            out.write("<script type=\"text/javascript\">");
            ClientConfigElement clientConfig = Application.getClientConfig(this.pageContext.getServletContext());
            if (clientConfig != null && clientConfig.getCheckContextAgainstPath()) {
                out.write("setCheckContextAgainstPath(true);");
            }
            out.write("setContextPath('");
            out.write(reqPath);
            out.write("');");
            PageTag.generateWindowOnloadCode((Writer)out);
            out.write("</script>\n");
            if (!Application.inPortalServer()) {
                out.write("</head>");
                out.write("<body>\n");
            }
        }
        catch (IOException ioe) {
            throw new JspException(ioe.toString());
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
            if (!req.getRequestURI().endsWith(this.getLoginPage())) {
                this.pageContext.getOut().write(this.getAlfrescoButton());
            }
            if (!Application.inPortalServer()) {
                this.pageContext.getOut().write("\n</body></html>");
            }
        }
        catch (IOException ioe) {
            throw new JspException(ioe.toString());
        }
        if (logger.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            logger.debug((Object)("Time to generate page: " + (endTime - this.startTime) + "ms"));
        }
        return super.doEndTag();
    }

    private String getLoginPage() {
        if (loginPage == null) {
            loginPage = Application.getLoginPage(this.pageContext.getServletContext());
        }
        return loginPage;
    }

    private String getAlfrescoButton() {
        if (alfresco == null) {
            HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
            alfresco = "<center><table style='margin: 0px auto;'><tr><td><a href='http://www.alfresco.com'><img style='vertical-align:middle;border-width:0px;' width='176' height='26' alt='' title='Alfresco Community' src='" + ("http".equals(req.getScheme()) ? ALF_LOGO_HTTP : ALF_LOGO_HTTPS) + "'>" + "</a></td><td align='center'>" + "<span class='footer'>" + ALF_COPY + "</span></td><td></td></tr></table></center>";
        }
        return alfresco;
    }

    private static void generateWindowOnloadCode(Writer out) throws IOException {
        CCProperties ccProps;
        FacesContext fc = FacesContext.getCurrentInstance();
        if (fc != null && ((ccProps = (CCProperties)FacesHelper.getManagedBean(fc, "CCProperties")).getWebdavUrl() != null || ccProps.getCifsPath() != null)) {
            out.write("window.onload=function(){onloadFunc(\"");
            if (ccProps.getWebdavUrl() != null) {
                out.write(ccProps.getWebdavUrl());
            }
            out.write("\",\"");
            if (ccProps.getCifsPath() != null) {
                String val = ccProps.getCifsPath();
                val = Utils.replace((String)val, (String)"\\", (String)"\\\\");
                out.write(val);
            }
            out.write("\");};");
            ccProps.setCifsPath(null);
            ccProps.setWebdavUrl(null);
        }
    }
}

