/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.tag;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.portlet.AlfrescoFacesPortlet;
import org.alfresco.web.app.servlet.ExternalAccessServlet;
import org.alfresco.web.bean.ErrorBean;
import org.alfresco.web.ui.common.Utils;

public class SystemErrorTag
extends TagSupport {
    private static final long serialVersionUID = -7336055169875448199L;
    private static final String MSG_RETURN_TO_APP = "return_to_application";
    private static final String MSG_RETURN_HOME = "return_home";
    private static final String MSG_HIDE_DETAILS = "hide_details";
    private static final String MSG_SHOW_DETAILS = "show_details";
    private static final String MSG_LOGOUT = "logout";
    private static final String MSG_ERROR_NOT_STORED = "error_not_stored";
    private static final String MSG_ERROR_NO_STACK_TRACE = "error_no_stack_trace";
    private static final String MSG_CAUSED_BY = "caused_by";
    private String styleClass;
    private String detailsStyleClass;
    private boolean showDetails = false;

    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getDetailsStyleClass() {
        return this.detailsStyleClass;
    }

    public void setDetailsStyleClass(String detailsStyleClass) {
        this.detailsStyleClass = detailsStyleClass;
    }

    public int doStartTag() throws JspException {
        ErrorBean errorBean = null;
        errorBean = Application.inPortalServer() ? AlfrescoFacesPortlet.getErrorBean(this.pageContext.getRequest()) : (ErrorBean)this.pageContext.getSession().getAttribute("alfresco.ErrorBean");
        if (errorBean == null) {
            Throwable error = (Throwable)this.pageContext.getRequest().getAttribute("javax.servlet.error.exception");
            String uri = (String)this.pageContext.getRequest().getAttribute("javax.servlet.error.request_uri");
            errorBean = new ErrorBean();
            this.pageContext.getSession().setAttribute("alfresco.ErrorBean", (Object)errorBean);
            errorBean.setLastError(error);
            errorBean.setReturnPage(uri);
        }
        Throwable lastError = errorBean.getLastError();
        try {
            String errorDetails;
            String errorMessage;
            JspWriter out = this.pageContext.getOut();
            ResourceBundle bundle = Application.getBundle(this.pageContext.getSession());
            if (lastError == null) {
                String messageKey = errorBean.getErrorMessageKey();
                errorMessage = bundle.getString(messageKey == null ? MSG_ERROR_NOT_STORED : messageKey);
                errorDetails = bundle.getString(MSG_ERROR_NO_STACK_TRACE);
            } else {
                errorMessage = this.getLastErrorMessage(lastError, bundle);
                errorDetails = this.getStackTrace(lastError);
            }
            out.write("<div");
            if (this.styleClass != null) {
                out.write(" class='");
                out.write(this.styleClass);
                out.write("'");
            }
            out.write(">");
            out.write(errorMessage);
            out.write("</div>");
            boolean hidden = !this.showDetails;
            String display = "inline";
            String toggleTitle = "Hide";
            if (hidden) {
                display = "none";
                toggleTitle = "Show";
            }
            out.write("<script language='JavaScript'>\n");
            out.write("var hidden = ");
            out.write(Boolean.toString(hidden));
            out.write(";\n");
            out.write("function toggleDetails() {\n");
            out.write("if (hidden) {\n");
            out.write("document.getElementById('detailsTitle').innerHTML = '");
            out.write(bundle.getString(MSG_HIDE_DETAILS));
            out.write("<br/><br/>';\n");
            out.write("document.getElementById('details').style.display = 'inline';\n");
            out.write("hidden = false;\n");
            out.write("} else {\n");
            out.write("document.getElementById('detailsTitle').innerHTML = '");
            out.write(bundle.getString(MSG_SHOW_DETAILS));
            out.write("';\n");
            out.write("document.getElementById('details').style.display = 'none';\n");
            out.write("hidden = true;\n");
            out.write("} } </script>\n");
            out.write("<br/>");
            out.write("<a id='detailsTitle' href='javascript:toggleDetails();'>");
            out.write(toggleTitle);
            out.write(" Details</a>");
            out.write("<div style='padding-top:5px;display:");
            out.write(display);
            out.write("' id='details'");
            if (this.detailsStyleClass != null) {
                out.write(" class='");
                out.write(this.detailsStyleClass);
                out.write("'");
            }
            out.write(">");
            out.write(errorDetails);
            out.write("</div>");
            out.write("\n<div style='padding-top:16px;'><a href='");
            if (Application.inPortalServer()) {
                String url = AlfrescoFacesPortlet.getRenderURL(this.pageContext.getRequest(), Collections.singletonMap("org.apache.myfaces.portlet.MyFacesGenericPortlet.VIEW_ID", new String[]{"current-view"}));
                out.write(url.toString());
            } else {
                String returnPage = null;
                if (errorBean != null) {
                    returnPage = errorBean.getReturnPage();
                }
                if (returnPage == null) {
                    out.write("javascript:history.back();");
                } else {
                    out.write(returnPage);
                }
            }
            out.write("'>");
            out.write(bundle.getString(MSG_RETURN_TO_APP));
            out.write("</a></div>");
            if (!Application.inPortalServer()) {
                out.write("\n<div style='padding-top:16px;'><a href='");
                out.write(((HttpServletRequest)this.pageContext.getRequest()).getContextPath());
                out.write("'>");
                out.write(bundle.getString(MSG_RETURN_HOME));
                out.write("</a></div>");
                out.write("\n<div style='padding-top:16px;'><a href='");
                out.write(((HttpServletRequest)this.pageContext.getRequest()).getContextPath());
                out.write(ExternalAccessServlet.generateExternalURL(MSG_LOGOUT, null));
                out.write("'>");
                out.write(bundle.getString(MSG_LOGOUT));
                out.write("</a></div>");
            }
        }
        catch (IOException ioe) {
            throw new JspException((Throwable)ioe);
        }
        finally {
            this.pageContext.getSession().removeAttribute("alfresco.ErrorBean");
        }
        return 0;
    }

    public void release() {
        this.styleClass = null;
        super.release();
    }

    private String getLastErrorMessage(Throwable lastError, ResourceBundle bundle) {
        StringBuilder builder = new StringBuilder(lastError.toString());
        Throwable cause = lastError.getCause();
        while (cause != null) {
            builder.append("\n").append(bundle.getString(MSG_CAUSED_BY)).append("\n");
            builder.append(cause.toString());
            if (cause instanceof ServletException && ((ServletException)cause).getRootCause() != null) {
                cause = ((ServletException)cause).getRootCause();
                continue;
            }
            cause = cause.getCause();
        }
        String message = Utils.encode((String)builder.toString());
        message = message.replaceAll("\n", "<br>");
        return message;
    }

    private String getStackTrace(Throwable lastError) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        lastError.printStackTrace(writer);
        String trace = Utils.encode((String)stringWriter.toString());
        trace = trace.replaceAll("\n", "<br>");
        return trace;
    }
}

