/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.wcm.component;

import java.io.IOException;
import java.io.Writer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormProcessor;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;
import org.w3c.dom.Document;

public class UIFormProcessor
extends SelfRenderingComponent {
    private static final Log LOGGER = LogFactory.getLog(UIFormProcessor.class);
    private Document formInstanceData = null;
    private String formInstanceDataName = null;
    private Form form = null;
    private FormProcessor.Session formProcessorSession = null;

    public String getFamily() {
        return "org.alfresco.faces.FormProcessor";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.formInstanceData = (Document)values[1];
        this.formInstanceDataName = (String)values[2];
        this.form = (Form)values[3];
        this.formProcessorSession = (FormProcessor.Session)values[4];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.formInstanceData, this.formInstanceDataName, this.form, this.formProcessorSession};
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        Form form = this.getForm();
        FormProcessor fp = form.getFormProcessors().get(0);
        FormProcessor.Session fps = this.getFormProcessorSession();
        Document fid = this.getFormInstanceData();
        String formInstanceDataName = this.getFormInstanceDataName();
        try {
            if (fps != null && fps.getForm().equals(form) && fps.getFormInstanceData().equals(fid)) {
                LOGGER.debug((Object)("reusing form processor session " + fps));
                fp.process(this.formProcessorSession, (Writer)out);
            } else {
                if (fps != null) {
                    this.setFormProcessorSession(null);
                    LOGGER.debug((Object)("clearing form instance data " + fid));
                    fid.removeChild(fid.getDocumentElement());
                }
                LOGGER.debug((Object)("creating a new session for " + fid));
                this.setFormProcessorSession(fp.process(fid, formInstanceDataName, form, (Writer)out));
            }
        }
        catch (Throwable t) {
            Utils.addErrorMessage(t.getMessage(), t);
            out.write(t.toString());
        }
    }

    public Document getFormInstanceData() {
        ValueBinding vb = this.getValueBinding("formInstanceData");
        if (vb != null) {
            this.formInstanceData = (Document)vb.getValue(this.getFacesContext());
        }
        return this.formInstanceData;
    }

    public void setFormInstanceData(Document formInstanceData) {
        this.formInstanceData = formInstanceData;
    }

    public String getFormInstanceDataName() {
        ValueBinding vb = this.getValueBinding("formInstanceDataName");
        if (vb != null) {
            this.formInstanceDataName = (String)vb.getValue(this.getFacesContext());
        }
        return this.formInstanceDataName;
    }

    public void setForm(String formInstanceDataName) {
        this.formInstanceDataName = formInstanceDataName;
    }

    public Form getForm() {
        ValueBinding vb = this.getValueBinding("form");
        if (vb != null) {
            this.form = (Form)vb.getValue(this.getFacesContext());
        }
        return this.form;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public FormProcessor.Session getFormProcessorSession() {
        ValueBinding vb = this.getValueBinding("formProcessorSession");
        if (vb != null) {
            this.formProcessorSession = (FormProcessor.Session)vb.getValue(this.getFacesContext());
        }
        LOGGER.debug((Object)("getFormProcessorSession() = " + this.formProcessorSession));
        return this.formProcessorSession;
    }

    public void setFormProcessorSession(FormProcessor.Session formProcessorSession) {
        if (formProcessorSession == null && this.formProcessorSession != null) {
            LOGGER.debug((Object)("destroying old session " + this.formProcessorSession));
            this.formProcessorSession.destroy();
        }
        this.formProcessorSession = formProcessorSession;
        ValueBinding vb = this.getValueBinding("formProcessorSession");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)formProcessorSession);
        }
    }
}

