/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import junit.framework.TestCase;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.extensions.webscripts.servlet.mvc.WebScriptViewResolver;
import org.springframework.web.servlet.View;

public class WebScriptViewResolverTest
extends TestCase {
    public void testEmptyViewURI() throws Exception {
        View view = this.getViewResolver().resolveViewName("", null);
        WebScriptViewResolverTest.assertTrue((view == null ? 1 : 0) != 0);
    }

    public void testSlashViewURI() throws Exception {
        View view = this.getViewResolver().resolveViewName("/", null);
        WebScriptViewResolverTest.assertTrue((view == null ? 1 : 0) != 0);
    }

    public void testBogusViewURI() throws Exception {
        View view = this.getViewResolver().resolveViewName("/test/bogus", null);
        WebScriptViewResolverTest.assertTrue((view != null ? 1 : 0) != 0);
    }

    private WebScriptViewResolver getViewResolver() {
        TestWebScriptServer server = TestWebScriptServer.getTestServer();
        WebScriptViewResolver resolver = new WebScriptViewResolver();
        resolver.setApplicationContext(server.applicationContext);
        resolver.setContainer(server.container);
        resolver.onBootstrap();
        return resolver;
    }
}

