/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Test;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.annotation.ScriptMethodType;
import org.springframework.extensions.webscripts.annotation.ScriptParameter;
import org.springframework.extensions.webscripts.annotation.samples.SampleMessage;

public class WebscriptAnnotation2Test
extends TestCase {
    private Set<BeanDefinition> components;

    protected void setUp() throws Exception {
        super.setUp();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
        String basePackage = "org.springframework.extensions.webscripts.annotation";
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ScriptClass.class));
        this.components = provider.findCandidateComponents(basePackage);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testAnnotatedJavaScriptAPIClass() throws Exception {
        boolean foundSampleMessageBean = false;
        for (BeanDefinition component : this.components) {
            if (!component.getBeanClassName().equals(SampleMessage.class.getName())) continue;
            foundSampleMessageBean = true;
            Class<?> beanClass = Class.forName(component.getBeanClassName());
            ScriptClass wsc = beanClass.getAnnotation(ScriptClass.class);
            WebscriptAnnotation2Test.assertNotNull((Object)wsc);
            WebscriptAnnotation2Test.assertNotNull((Object)wsc.help());
            WebscriptAnnotation2Test.assertNotNull((Object)wsc.code());
            HashSet<ScriptClassType> types = new HashSet<ScriptClassType>(Arrays.asList(wsc.types()));
            WebscriptAnnotation2Test.assertTrue((boolean)types.contains(ScriptClassType.JavaScriptAPI));
            Method m = beanClass.getMethod("splitMsg", String.class);
            WebscriptAnnotation2Test.assertNotNull((Object)m);
            ScriptMethod wsm = m.getAnnotation(ScriptMethod.class);
            WebscriptAnnotation2Test.assertNotNull((Object)wsm);
            WebscriptAnnotation2Test.assertNotNull((Object)wsm.code());
            WebscriptAnnotation2Test.assertNotNull((Object)wsm.help());
            WebscriptAnnotation2Test.assertNotNull((Object)wsm.output());
            WebscriptAnnotation2Test.assertTrue((boolean)wsm.type().equals((Object)ScriptMethodType.READ));
            Annotation[][] wsps = m.getParameterAnnotations();
            WebscriptAnnotation2Test.assertNotNull((Object)wsps);
            Annotation[] wsps1 = wsps[0];
            WebscriptAnnotation2Test.assertNotNull((Object)wsps1);
            Annotation wspObj = wsps1[0];
            WebscriptAnnotation2Test.assertTrue((boolean)(wspObj instanceof ScriptParameter));
            ScriptParameter wsp = (ScriptParameter)wspObj;
            WebscriptAnnotation2Test.assertNotNull((Object)wsp.help());
            WebscriptAnnotation2Test.assertNotNull((Object)wsp.name());
        }
        WebscriptAnnotation2Test.assertTrue((boolean)foundSampleMessageBean);
    }
}

