/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.NowikiTag;
import java.io.IOException;

public class MathTag
extends NowikiTag {
    public MathTag() {
        super("math");
    }

    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            writer.append("<span class=\"math\">");
            MathTag.copyMathLTGT(content, writer);
            writer.append("</span>");
        }
    }

    public void renderLaTeX(ITextConverter converter, Appendable _out, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            _out.append("\\begin{math}\n");
            _out.append(String.valueOf(content) + "\n");
            _out.append("\\end{math}");
        }
    }

    public boolean isReduceTokenStack() {
        return true;
    }
}

