/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;

public class SerializableTypeHandlerCallback
implements TypeHandlerCallback {
    public static final int DEFAULT_SERIALIZABLE_TYPE = -4;
    private static volatile int serializableType = -4;

    public static void setSerializableType(int serializableType) {
        SerializableTypeHandlerCallback.serializableType = serializableType;
    }

    public static int getSerializableType() {
        return serializableType;
    }

    public Object getResult(ResultGetter getter) throws SQLException {
        Serializable ret;
        try {
            InputStream is = getter.getResultSet().getBinaryStream(getter.getColumnName());
            if (is == null || getter.wasNull()) {
                return null;
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            Object obj = ois.readObject();
            ret = (Serializable)obj;
        }
        catch (Throwable e) {
            throw new DeserializationException(e);
        }
        return ret;
    }

    public void setParameter(ParameterSetter setter, Object parameter) throws SQLException {
        if (parameter == null) {
            setter.setNull(serializableType);
        } else {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(parameter);
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                setter.setBinaryStream((InputStream)bais, bytes.length);
            }
            catch (Throwable e) {
                throw new SerializationException(e);
            }
        }
    }

    public Object valueOf(String s) {
        return s;
    }

    public static class SerializationException
    extends RuntimeException {
        private static final long serialVersionUID = 962957884262870228L;

        public SerializationException(Throwable cause) {
            super(cause);
        }
    }

    public static class DeserializationException
    extends RuntimeException {
        private static final long serialVersionUID = 4673487701048985340L;

        public DeserializationException(Throwable cause) {
            super(cause);
        }
    }
}

