/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.exec;

import java.io.File;
import java.util.Arrays;
import junit.framework.TestCase;
import org.alfresco.util.exec.RuntimeExec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RuntimeExecBeansTest
extends TestCase {
    private static Log logger = LogFactory.getLog(RuntimeExecBeansTest.class);
    private static final String APP_CONTEXT_XML = "classpath:org/alfresco/util/exec/RuntimeExecBeansTest-context.xml";
    private static final String DIR = "dir RuntimeExecBootstrapBeanTest";
    private File dir;

    public void setUp() throws Exception {
        this.dir = new File(DIR);
        this.dir.mkdir();
        RuntimeExecBeansTest.assertTrue((String)"Directory not created", (boolean)this.dir.exists());
    }

    public void testBootstrapAndShutdown() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(APP_CONTEXT_XML);
        RuntimeExecBeansTest.assertFalse((String)"Folder was not deleted by bootstrap", (boolean)this.dir.exists());
        this.dir.mkdir();
        RuntimeExecBeansTest.assertTrue((String)"Directory not created", (boolean)this.dir.exists());
        ctx.publishEvent((ApplicationEvent)new ContextClosedEvent((ApplicationContext)ctx));
        RuntimeExecBeansTest.assertFalse((String)"Folder was not deleted by shutdown", (boolean)this.dir.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleSuccess() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(APP_CONTEXT_XML);
        try {
            RuntimeExec dirRootExec = (RuntimeExec)ctx.getBean("commandListRootDir");
            RuntimeExecBeansTest.assertNotNull((Object)dirRootExec);
            dirRootExec.execute();
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeprecatedSetCommandMap() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(APP_CONTEXT_XML);
        try {
            RuntimeExec deprecatedExec = (RuntimeExec)ctx.getBean("commandCheckDeprecatedSetCommandMap");
            RuntimeExecBeansTest.assertNotNull((Object)deprecatedExec);
            deprecatedExec.execute();
        }
        finally {
            ctx.close();
        }
        logger.warn((Object)"There should be a warning re. the use of deprecated 'setCommandMap'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitArguments() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(APP_CONTEXT_XML);
        try {
            RuntimeExec splitExec = (RuntimeExec)ctx.getBean("commandSplitArguments");
            RuntimeExecBeansTest.assertNotNull((Object)splitExec);
            Object[] splitCommand = splitExec.getCommand();
            RuntimeExecBeansTest.assertTrue((String)("Command arguments not split into 'dir', '.' and '..' :" + Arrays.deepToString(splitCommand)), (boolean)Arrays.deepEquals(new String[]{"dir", ".", ".."}, splitCommand));
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitArgumentsAsSingleValue() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(APP_CONTEXT_XML);
        try {
            RuntimeExec splitExec = (RuntimeExec)ctx.getBean("commandSplitArgumentsAsSingleValue");
            RuntimeExecBeansTest.assertNotNull((Object)splitExec);
            Object[] splitCommand = splitExec.getCommand();
            RuntimeExecBeansTest.assertTrue((String)("Command arguments not split into 'dir', '.' and '..' : " + Arrays.deepToString(splitCommand)), (boolean)Arrays.deepEquals(new String[]{"dir", ".", ".."}, splitCommand));
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailureModeOfMissingCommand() {
        File dir = new File(DIR);
        dir.mkdir();
        RuntimeExecBeansTest.assertTrue((String)"Directory not created", (boolean)dir.exists());
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(APP_CONTEXT_XML);
        try {
            RuntimeExec failureExec = (RuntimeExec)ctx.getBean("commandFailureGuaranteed");
            RuntimeExecBeansTest.assertNotNull((Object)failureExec);
            RuntimeExec.ExecutionResult result = failureExec.execute();
            RuntimeExecBeansTest.assertEquals((String)"Expected first error code in list", (int)666, (int)result.getExitValue());
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecOfNeverEndingProcess() {
        File dir = new File(DIR);
        dir.mkdir();
        RuntimeExecBeansTest.assertTrue((String)"Directory not created", (boolean)dir.exists());
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(APP_CONTEXT_XML);
        try {
            RuntimeExec failureExec = (RuntimeExec)ctx.getBean("commandNeverEnding");
            RuntimeExecBeansTest.assertNotNull((Object)failureExec);
            failureExec.execute();
        }
        finally {
            ctx.close();
        }
    }
}

