/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.portlet;

import java.io.IOException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.portlet.PortletAuthenticatorFactory;

public class WebClientPortletAuthenticatorFactory
implements PortletAuthenticatorFactory {
    public Authenticator create(RenderRequest req, RenderResponse res) {
        return new WebClientPortletAuthenticator(req, res);
    }

    public class WebClientPortletAuthenticator
    implements Authenticator {
        private RenderRequest req;
        private RenderResponse res;

        public WebClientPortletAuthenticator(RenderRequest req, RenderResponse res) {
            this.req = req;
            this.res = res;
        }

        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            PortletSession session = this.req.getPortletSession();
            this.req.setAttribute("_alf_requiredAuth", (Object)required);
            this.req.setAttribute("_alf_isGuest", (Object)isGuest);
            PortletContext context = session.getPortletContext();
            try {
                context.getNamedDispatcher("authenticatorServlet").include(this.req, this.res);
            }
            catch (PortletException e) {
                throw new WebScriptException("Failed to authenticate", (Throwable)e);
            }
            catch (IOException e) {
                throw new WebScriptException("Failed to authenticate", (Throwable)e);
            }
            AuthenticationStatus status = (AuthenticationStatus)((Object)this.req.getAttribute("_alf_authStatus"));
            return status != null && status != AuthenticationStatus.Failure;
        }

        public boolean emptyCredentials() {
            return true;
        }
    }
}

