/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.action.evaluator;

import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.web.action.evaluator.BaseActionEvaluator;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.ml.MultilingualUtils;
import org.alfresco.web.bean.repository.Node;

public class DeleteDocEvaluator
extends BaseActionEvaluator {
    private static final long serialVersionUID = 5742287199692844685L;

    public boolean evaluate(Node node) {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (node.getType().equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER)) {
            return MultilingualUtils.canDeleteEachTranslation(node, fc);
        }
        boolean isPivot = false;
        if (node.getAspects().contains(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT)) {
            MultilingualContentService mlservice = (MultilingualContentService)FacesHelper.getManagedBean(fc, "MultilingualContentService");
            if (mlservice.getTranslations(node.getNodeRef()).size() == 1) {
                isPivot = false;
            } else if (mlservice.getPivotTranslation(node.getNodeRef()).getId().equalsIgnoreCase(node.getNodeRef().getId())) {
                isPivot = true;
            }
        }
        return !node.isLocked() && !node.hasAspect(ContentModel.ASPECT_WORKING_COPY) && !isPivot;
    }
}

