/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.web.app.servlet.AuthenticationHelper;
import org.alfresco.web.bean.repository.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdminAuthenticationFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(AdminAuthenticationFilter.class);
    private FilterConfig config;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        User user;
        boolean isAdmin;
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        HttpServletResponse httpResponse = (HttpServletResponse)res;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authorising request for protected resource: " + httpRequest.getRequestURI()));
        }
        boolean bl = isAdmin = (user = AuthenticationHelper.getUser(this.config.getServletContext(), httpRequest, httpResponse)) != null && user.isAdmin();
        if (isAdmin) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Current user has admin authority, allowing access.");
            }
            chain.doFilter(req, res);
        } else if (!httpResponse.isCommitted()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Current user does not have admin authority, returning 401 Forbidden error...");
            }
            httpResponse.sendError(403);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Access denied to '" + httpRequest.getRequestURI() + "'. The response has already been committed so a 401 Forbidden error could not be sent!"));
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    public void destroy() {
    }
}

