/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseServlet;
import org.alfresco.web.app.servlet.command.CommandFactory;
import org.alfresco.web.app.servlet.command.CommandProcessor;
import org.alfresco.web.app.servlet.command.ExtCommandProcessor;
import org.alfresco.web.config.CommandServletConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;

public class CommandServlet
extends BaseServlet {
    private static final long serialVersionUID = -5432407921038376133L;
    private static Log logger = LogFactory.getLog(CommandServlet.class);
    private static CommandFactory commandfactory = CommandFactory.getInstance();
    public static final String ARG_RETURNPAGE = "return-page";

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        AuthenticationStatus status;
        String uri = req.getRequestURI();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing URL: " + uri + (req.getQueryString() != null ? "?" + req.getQueryString() : "")));
        }
        if ((status = this.servletAuthenticate(req, res)) == AuthenticationStatus.Failure) {
            return;
        }
        CommandServlet.setNoCacheHeaders(res);
        uri = uri.substring(req.getContextPath().length());
        StringTokenizer t = new StringTokenizer(uri, "/");
        int tokenCount = t.countTokens();
        if (tokenCount < 3) {
            throw new IllegalArgumentException("Command Servlet URL did not contain all required args: " + uri);
        }
        t.nextToken();
        String procName = t.nextToken();
        String command = t.nextToken();
        String[] urlElements = new String[tokenCount - 3];
        for (int i = 0; i < tokenCount - 3; ++i) {
            urlElements[i] = t.nextToken();
        }
        HashMap<String, String> args = new HashMap<String, String>(8, 1.0f);
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            args.put(name, req.getParameter(name));
        }
        try {
            CommandProcessor processor = this.createCommandProcessor(procName);
            if (!processor.validateArguments(this.getServletContext(), command, args, urlElements)) {
                CommandServlet.redirectToLoginPage(req, res, this.getServletContext());
                return;
            }
            ServiceRegistry serviceRegistry = CommandServlet.getServiceRegistry(this.getServletContext());
            UserTransaction txn = null;
            try {
                txn = serviceRegistry.getTransactionService().getUserTransaction();
                txn.begin();
                if (processor instanceof ExtCommandProcessor) {
                    ((ExtCommandProcessor)processor).process(serviceRegistry, req, res, command);
                } else {
                    processor.process(serviceRegistry, req, command);
                }
                txn.commit();
            }
            catch (Throwable txnErr) {
                try {
                    if (txn != null) {
                        txn.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
                throw txnErr;
            }
            String returnPage = req.getParameter(ARG_RETURNPAGE);
            if (returnPage != null && returnPage.length() != 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Redirecting to specified return page: " + returnPage));
                }
                res.sendRedirect(returnPage);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No return page specified, displaying status output.");
                }
                if (res.getContentType() == null) {
                    res.setContentType("text/html");
                }
                PrintWriter out = res.getWriter();
                processor.outputStatus(out);
                out.close();
            }
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException("Error during command servlet processing: " + err.getMessage(), err);
        }
    }

    private CommandProcessor createCommandProcessor(String procName) throws InstantiationException, IllegalAccessException {
        Config config = Application.getConfigService(this.getServletContext()).getConfig((Object)"Command Servlet");
        if (config == null) {
            throw new AlfrescoRuntimeException("No command processors configured - unable to process any commands.");
        }
        CommandServletConfigElement configElement = (CommandServletConfigElement)config.getConfigElement("command-servlet");
        if (configElement == null) {
            throw new AlfrescoRuntimeException("No command processors configured - unable to process any commands.");
        }
        Class clazz = configElement.getCommandProcessor(procName);
        Object obj = clazz.newInstance();
        if (!(obj instanceof CommandProcessor)) {
            throw new AlfrescoRuntimeException("Configured command processor '" + procName + "' is does not implement interface CommandProcessor!");
        }
        return (CommandProcessor)obj;
    }
}

