/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.web.app.servlet.command.Command;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CommandFactory {
    private static Log logger = LogFactory.getLog(CommandFactory.class);
    private static CommandFactory instance = new CommandFactory();
    private static Map<String, Class> registry = new HashMap<String, Class>(16, 1.0f);

    private CommandFactory() {
    }

    public static CommandFactory getInstance() {
        return instance;
    }

    public void registerCommand(String name, Class clazz) {
        registry.put(name, clazz);
    }

    public Command createCommand(String name) {
        Command result = null;
        Class clazz = registry.get(name);
        if (clazz != null) {
            try {
                Object obj = clazz.newInstance();
                if (obj instanceof Command) {
                    result = (Command)obj;
                }
            }
            catch (Throwable err) {
                logger.warn((Object)("Unable to create workflow command instance '" + name + "' with classname '" + clazz.getName() + "' due to error: " + err.getMessage()));
            }
        }
        return result;
    }
}

