/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.app.servlet.command.BaseUIActionCommand;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditWebContentCommand
extends BaseUIActionCommand {
    public static final String PROP_WEBPROJECTID = "webproject";
    public static final String PROP_SANDBOX = "sandbox";
    public static final String PROP_PATH = "path";
    private static final String[] PROPERTIES = new String[]{"ServletContext", "Request", "Response", "webproject", "sandbox", "path"};

    @Override
    public Object execute(ServiceRegistry serviceRegistry, Map<String, Object> properties) {
        ServletContext sc = (ServletContext)properties.get("ServletContext");
        ServletRequest req = (ServletRequest)properties.get("Request");
        ServletResponse res = (ServletResponse)properties.get("Response");
        FacesContext fc = FacesHelper.getFacesContext(req, res, sc);
        AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(fc, "AVMBrowseBean");
        NavigationBean navigator = (NavigationBean)FacesHelper.getManagedBean(fc, "NavigationBean");
        String webProjectId = (String)properties.get(PROP_WEBPROJECTID);
        ParameterCheck.mandatoryString((String)PROP_WEBPROJECTID, (String)webProjectId);
        String sandbox = (String)properties.get(PROP_SANDBOX);
        ParameterCheck.mandatoryString((String)PROP_SANDBOX, (String)sandbox);
        String path = (String)properties.get(PROP_PATH);
        ParameterCheck.mandatoryString((String)PROP_PATH, (String)path);
        navigator.setCurrentNodeId(webProjectId);
        avmBrowseBean.setSandbox(sandbox);
        avmBrowseBean.setupEditAction(path);
        String viewId = fc.getViewRoot().getViewId();
        try {
            sc.getRequestDispatcher("/faces" + viewId).forward(req, res);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Unable to forward to viewId: " + viewId, (Throwable)e);
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return PROPERTIES;
    }
}

