/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.web.app.servlet.command.Command;
import org.alfresco.web.app.servlet.command.CommandFactory;
import org.alfresco.web.app.servlet.command.CommandProcessor;
import org.alfresco.web.app.servlet.command.EndTaskCommand;
import org.alfresco.web.ui.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskCommandProcessor
implements CommandProcessor {
    private String taskId;
    private String transition = null;
    private String command;

    @Override
    public boolean validateArguments(ServletContext sc, String command, Map<String, String> args, String[] urlElements) {
        if (urlElements.length == 0) {
            throw new IllegalArgumentException("Not enough URL arguments passed to command servlet.");
        }
        this.taskId = urlElements[0];
        if (urlElements.length == 2) {
            this.transition = urlElements[1];
        }
        return true;
    }

    @Override
    public void process(ServiceRegistry serviceRegistry, HttpServletRequest request, String command) {
        Command cmd;
        HashMap<String, Object> properties = new HashMap<String, Object>(1, 1.0f);
        properties.put("taskId", this.taskId);
        if (this.transition != null) {
            properties.put("transition", this.transition);
        }
        if ((cmd = CommandFactory.getInstance().createCommand(command)) == null) {
            throw new AlfrescoRuntimeException("Unregistered workflow command specified: " + command);
        }
        cmd.execute(serviceRegistry, properties);
        this.command = command;
    }

    @Override
    public void outputStatus(PrintWriter out) {
        out.print("Task command: '");
        out.print(Utils.encode((String)this.command));
        out.print("' executed against task: ");
        out.println(Utils.encode((String)this.taskId));
    }

    static {
        CommandFactory.getInstance().registerCommand("end", EndTaskCommand.class);
    }
}

