/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.workflow.WorkflowUtil;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDetailsBean
extends BaseDialogBean {
    private static final String MSG_SUCCESS_OWNERSHIP = "success_ownership";
    private transient OwnableService ownableService;
    private transient CopyService copyService;
    private transient PermissionService permissionService;
    protected String template;
    protected Map<String, Serializable> workflowProperties;
    protected Map<String, Boolean> panels = new HashMap<String, Boolean>(4, 1.0f);
    private static final String MSG_ERROR_WORKFLOW_REJECT = "error_workflow_reject";
    private static final String MSG_ERROR_WORKFLOW_APPROVE = "error_workflow_approve";
    private static final String MSG_ERROR_UPDATE_SIMPLEWORKFLOW = "error_update_simpleworkflow";
    protected TemplateImageResolver imageResolver = new TemplateImageResolver(){
        private static final long serialVersionUID = 1539708282743314697L;

        public String resolveImagePathForName(String filename, FileTypeImageSize size) {
            return FileTypeImageUtils.getFileTypeImage((FacesContext)FacesContext.getCurrentInstance(), (String)filename, (FileTypeImageSize)size);
        }
    };

    public BaseDetailsBean() {
        this.panels.put("workflow-panel", false);
        this.panels.put("category-panel", false);
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    protected OwnableService getOwnableService() {
        if (this.ownableService == null) {
            this.ownableService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getOwnableService();
        }
        return this.ownableService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    protected CopyService getCopyService() {
        if (this.copyService == null) {
            this.copyService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCopyService();
        }
        return this.copyService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public Map<String, Boolean> getPanels() {
        return this.panels;
    }

    public void setPanels(Map<String, Boolean> panels) {
        this.panels = panels;
    }

    public abstract Node getNode();

    public String getId() {
        return this.getNode().getId();
    }

    public String getName() {
        return this.getNode().getName();
    }

    public String getNodeRefUrl() {
        return this.getNode().getNodeRef().toString();
    }

    public String getWebdavUrl() {
        Node node = this.getLinkResolvedNode();
        return Utils.generateURL(FacesContext.getCurrentInstance(), node, Utils.URLMode.WEBDAV);
    }

    public String getCifsPath() {
        Node node = this.getLinkResolvedNode();
        return Utils.generateURL(FacesContext.getCurrentInstance(), node, Utils.URLMode.CIFS);
    }

    public String getBookmarkUrl() {
        return Utils.generateURL(FacesContext.getCurrentInstance(), this.getNode(), Utils.URLMode.SHOW_DETAILS);
    }

    protected abstract Node getLinkResolvedNode();

    public String getTemplate() {
        NodeRef ref = (NodeRef)this.getNode().getProperties().get(ContentModel.PROP_TEMPLATE);
        return ref != null ? ref.getId() : this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean getHasCustomView() {
        return this.getHasWebscriptView() || this.getHasTemplateView();
    }

    public boolean getHasTemplateView() {
        if (this.getNode().hasAspect(ContentModel.ASPECT_TEMPLATABLE)) {
            NodeRef templateRef = (NodeRef)this.getNode().getProperties().get(ContentModel.PROP_TEMPLATE);
            return templateRef != null && this.getNodeService().exists(templateRef) && this.getPermissionService().hasPermission(templateRef, "Read") == AccessStatus.ALLOWED;
        }
        return false;
    }

    public boolean getHasWebscriptView() {
        if (this.getNode().hasAspect(ContentModel.ASPECT_WEBSCRIPTABLE)) {
            return this.getNode().getProperties().get(ContentModel.PROP_WEBSCRIPT) != null;
        }
        return false;
    }

    public String getTemplateRef() {
        NodeRef ref = (NodeRef)this.getNode().getProperties().get(ContentModel.PROP_TEMPLATE);
        return ref != null ? ref.toString() : null;
    }

    public String getWebscriptUrl() {
        return (String)this.getNode().getProperties().get(ContentModel.PROP_WEBSCRIPT);
    }

    public abstract Map getTemplateModel();

    public Map<String, Serializable> getWorkflowProperties() {
        if (this.workflowProperties == null && this.getNode().hasAspect(ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            Map<String, Object> props = this.getNode().getProperties();
            String approveStepName = (String)props.get(ApplicationModel.PROP_APPROVE_STEP.toString());
            String rejectStepName = (String)props.get(ApplicationModel.PROP_REJECT_STEP.toString());
            Boolean approveMove = (Boolean)props.get(ApplicationModel.PROP_APPROVE_MOVE.toString());
            Boolean rejectMove = (Boolean)props.get(ApplicationModel.PROP_REJECT_MOVE.toString());
            NodeRef approveFolder = (NodeRef)props.get(ApplicationModel.PROP_APPROVE_FOLDER.toString());
            NodeRef rejectFolder = (NodeRef)props.get(ApplicationModel.PROP_REJECT_FOLDER.toString());
            this.workflowProperties = new HashMap<String, Serializable>(7);
            this.workflowProperties.put("approveStepName", (Serializable)((Object)approveStepName));
            this.workflowProperties.put("approveAction", (Serializable)((Object)(approveMove != false ? "move" : "copy")));
            this.workflowProperties.put("approveFolder", (Serializable)approveFolder);
            if (rejectStepName == null || rejectMove == null || rejectFolder == null) {
                this.workflowProperties.put("rejectStepPresent", (Serializable)((Object)"no"));
            } else {
                this.workflowProperties.put("rejectStepPresent", (Serializable)((Object)"yes"));
                this.workflowProperties.put("rejectStepName", (Serializable)((Object)rejectStepName));
                this.workflowProperties.put("rejectAction", (Serializable)((Object)(rejectMove != false ? "move" : "copy")));
                this.workflowProperties.put("rejectFolder", (Serializable)rejectFolder);
            }
        }
        return this.workflowProperties;
    }

    public String cancelWorkflowEdit() {
        this.workflowProperties.clear();
        this.workflowProperties = null;
        return "cancel";
    }

    public String saveWorkflow() {
        String outcome = "cancel";
        try {
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    Map updateProps = BaseDetailsBean.this.getNodeService().getProperties(BaseDetailsBean.this.getNode().getNodeRef());
                    updateProps.put(ApplicationModel.PROP_APPROVE_STEP, BaseDetailsBean.this.workflowProperties.get("approveStepName"));
                    boolean approveMove = true;
                    String approveAction = (String)((Object)BaseDetailsBean.this.workflowProperties.get("approveAction"));
                    if (approveAction != null && approveAction.equals("copy")) {
                        approveMove = false;
                    }
                    updateProps.put(ApplicationModel.PROP_APPROVE_MOVE, approveMove);
                    updateProps.put(ApplicationModel.PROP_APPROVE_FOLDER, BaseDetailsBean.this.workflowProperties.get("approveFolder"));
                    boolean requireReject = true;
                    String rejectStepPresent = (String)((Object)BaseDetailsBean.this.workflowProperties.get("rejectStepPresent"));
                    if (rejectStepPresent != null && rejectStepPresent.equals("no")) {
                        requireReject = false;
                    }
                    if (requireReject) {
                        updateProps.put(ApplicationModel.PROP_REJECT_STEP, BaseDetailsBean.this.workflowProperties.get("rejectStepName"));
                        boolean rejectMove = true;
                        String rejectAction = (String)((Object)BaseDetailsBean.this.workflowProperties.get("rejectAction"));
                        if (rejectAction != null && rejectAction.equals("copy")) {
                            rejectMove = false;
                        }
                        updateProps.put(ApplicationModel.PROP_REJECT_MOVE, rejectMove);
                        updateProps.put(ApplicationModel.PROP_REJECT_FOLDER, BaseDetailsBean.this.workflowProperties.get("rejectFolder"));
                    } else {
                        updateProps.put(ApplicationModel.PROP_REJECT_STEP, null);
                        updateProps.put(ApplicationModel.PROP_REJECT_MOVE, null);
                        updateProps.put(ApplicationModel.PROP_REJECT_FOLDER, null);
                    }
                    BaseDetailsBean.this.getNodeService().setProperties(BaseDetailsBean.this.getNode().getNodeRef(), updateProps);
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            this.getNode().reset();
            outcome = "finish";
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_UPDATE_SIMPLEWORKFLOW), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
        return outcome;
    }

    public String getApproveStepName() {
        String approveStepName = null;
        if (this.getNode().hasAspect(ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            approveStepName = (String)this.getNode().getProperties().get(ApplicationModel.PROP_APPROVE_STEP.toString());
        }
        return approveStepName;
    }

    public void approve(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id == null || id.length() == 0) {
            throw new AlfrescoRuntimeException("approve called without an id");
        }
        final NodeRef docNodeRef = new NodeRef(Repository.getStoreRef(), id);
        try {
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    WorkflowUtil.approve(docNodeRef, BaseDetailsBean.this.getNodeService(), BaseDetailsBean.this.getCopyService());
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            if (this.getNode() != null) {
                this.getNode().reset();
            }
            UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_WORKFLOW_APPROVE), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
    }

    public String getRejectStepName() {
        String approveStepName = null;
        if (this.getNode().hasAspect(ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            approveStepName = (String)this.getNode().getProperties().get(ApplicationModel.PROP_REJECT_STEP.toString());
        }
        return approveStepName;
    }

    public void reject(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id == null || id.length() == 0) {
            throw new AlfrescoRuntimeException("reject called without an id");
        }
        final NodeRef docNodeRef = new NodeRef(Repository.getStoreRef(), id);
        try {
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    WorkflowUtil.reject(docNodeRef, BaseDetailsBean.this.getNodeService(), BaseDetailsBean.this.getCopyService());
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            if (this.getNode() != null) {
                this.getNode().reset();
            }
            UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_WORKFLOW_REJECT), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
    }

    public void applyTemplate(ActionEvent event) {
        if (this.template != null && !this.template.equals("none")) {
            try {
                if (!this.getNode().hasAspect(ContentModel.ASPECT_TEMPLATABLE)) {
                    this.getNodeService().addAspect(this.getNode().getNodeRef(), ContentModel.ASPECT_TEMPLATABLE, null);
                }
                NodeRef templateRef = new NodeRef(Repository.getStoreRef(), this.template);
                this.getNodeService().setProperty(this.getNode().getNodeRef(), ContentModel.PROP_TEMPLATE, (Serializable)templateRef);
                this.getNode().reset();
            }
            catch (Exception e) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), e.getMessage()), e);
            }
        }
    }

    public void removeTemplate(ActionEvent event) {
        try {
            this.getNodeService().setProperty(this.getNode().getNodeRef(), ContentModel.PROP_TEMPLATE, null);
            this.getNodeService().removeAspect(this.getNode().getNodeRef(), ContentModel.ASPECT_TEMPLATABLE);
            this.getNodeService().removeAspect(this.getNode().getNodeRef(), ContentModel.ASPECT_WEBSCRIPTABLE);
            this.getNode().reset();
        }
        catch (Exception e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), e.getMessage()), e);
        }
    }

    public void takeOwnership(final ActionEvent event) {
        final FacesContext fc = FacesContext.getCurrentInstance();
        try {
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    BaseDetailsBean.this.getOwnableService().takeOwnership(BaseDetailsBean.this.getNode().getNodeRef());
                    String msg = Application.getMessage(fc, BaseDetailsBean.MSG_SUCCESS_OWNERSHIP);
                    FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
                    String formId = Utils.getParentForm(fc, event.getComponent()).getClientId(fc);
                    fc.addMessage(formId + ':' + BaseDetailsBean.this.getPropertiesPanelId(), facesMsg);
                    BaseDetailsBean.this.getNode().reset();
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(fc, "error_generic"), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
    }

    protected abstract String getPropertiesPanelId();

    public void expandPanel(ActionEvent event) {
        if (event instanceof UIPanel.ExpandedEvent) {
            String id = event.getComponent().getId();
            if (id.startsWith("no-")) {
                id = id.substring(3);
            }
            this.panels.put(id, ((UIPanel.ExpandedEvent)event).State);
        }
    }
}

