/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.bean.search.SearchContext;

public class CategoryBrowserBean {
    public static String BEAN_NAME = "CategoryBrowserBean";
    private NodeService nodeService;
    private NodeRef currentCategory = null;
    private boolean includeSubcategories = false;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCurrentCategory(NodeRef currentCategory) {
        this.currentCategory = currentCategory;
    }

    public String getCurrentCategoryName() {
        String currentCategoryName = null;
        if (this.currentCategory != null) {
            currentCategoryName = (String)((Object)this.nodeService.getProperty(this.currentCategory, ContentModel.PROP_NAME));
        }
        return currentCategoryName;
    }

    public boolean isIncludeSubcategories() {
        return this.includeSubcategories;
    }

    public void setIncludeSubcategories(boolean includeSubcategories) {
        this.includeSubcategories = includeSubcategories;
    }

    public SearchContext generateCategorySearchContext() {
        SearchContext categorySearch = new SearchContext();
        String[] categories = new String[]{SearchContext.getPathFromSpaceRef(this.currentCategory, this.includeSubcategories)};
        categorySearch.setText("");
        categorySearch.setCategories(categories);
        return categorySearch;
    }
}

