/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationDisallowedException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationMaxUsersException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.LoginOutcomeBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginBean
implements Serializable {
    private static final String OUTCOME_LOGOUT = "logout";
    private static final String OUTCOME_RELOGIN = "relogin";
    private static final String PARAM_OUTCOME = "outcome";
    private static final long serialVersionUID = 7417882503323795282L;
    private static final Log logger = LogFactory.getLog(LoginBean.class);
    private static final String MSG_ERROR_MISSING = "error_login_missing";
    private static final String MSG_ERROR_UNKNOWN_USER = "error_login_user";
    private static final String MSG_ERROR_LOGIN_DISALLOWED = "error_login_disallowed";
    private static final String MSG_ERROR_LOGIN_MAXUSERS = "error_login_maxusers";
    private static final String MSG_NONE = "none";
    public static final String MSG_ERROR_LOGIN_NOPERMISSIONS = "login_err_permissions";
    public static final String MSG_USERNAME_LENGTH = "login_err_username_length";
    public static final String MSG_PASSWORD_LENGTH = "login_err_password_length";
    public static final String MSG_USER_ERR = "user_err_user_name";
    public static final String LOGIN_EXTERNAL_AUTH = "_alfExternalAuth";
    public static final String LOGIN_NOPERMISSIONS = "_alfNoPermissions";
    private String username = null;
    private String password = null;
    private transient PersonService personService;
    private transient AuthenticationService authenticationService;
    private transient NodeService nodeService;
    protected BrowseBean browseBean;
    protected NavigationBean navigator;
    protected UserPreferencesBean preferences;

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected AuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthenticationService();
        }
        return this.authenticationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    public void setNavigator(NavigationBean navigator) {
        this.navigator = navigator;
    }

    public void setUserPreferencesBean(UserPreferencesBean preferences) {
        this.preferences = preferences;
    }

    public UserPreferencesBean getUserPreferencesBean() {
        return this.preferences;
    }

    public String getLogoutOutcome() {
        Map session = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        return session.get(LOGIN_EXTERNAL_AUTH) == null ? OUTCOME_LOGOUT : OUTCOME_RELOGIN;
    }

    public void setUsername(String val) {
        if (val != null) {
            val = val.trim();
        }
        this.username = val;
    }

    public String getUsername() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map session = context.getExternalContext().getSessionMap();
        String username = (String)session.get("_alfLastUser");
        if (username != null) {
            session.remove("_alfLastUser");
            this.username = username;
        }
        return this.username;
    }

    public String getUsernameInternal() {
        return this.username;
    }

    public void setPassword(String val) {
        this.password = val;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isLanguageSelect() {
        return Application.getClientConfig(FacesContext.getCurrentInstance()).isLanguageSelect();
    }

    public void validatePassword(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        int minPasswordLength = Application.getClientConfig(context).getMinPasswordLength();
        String pass = (String)value;
        if (pass.length() < minPasswordLength || pass.length() > 256) {
            String err = MessageFormat.format(Application.getMessage(context, MSG_PASSWORD_LENGTH), minPasswordLength, 256);
            throw new ValidatorException(new FacesMessage(err));
        }
    }

    public void validateUsername(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        int minUsernameLength = Application.getClientConfig(context).getMinUsernameLength();
        String name = ((String)value).trim();
        if (name.length() < minUsernameLength || name.length() > 256) {
            String err = MessageFormat.format(Application.getMessage(context, MSG_USERNAME_LENGTH), minUsernameLength, 256);
            throw new ValidatorException(new FacesMessage(err));
        }
        if (name.indexOf(34) != -1) {
            String err = MessageFormat.format(Application.getMessage(context, MSG_USER_ERR), "\"");
            throw new ValidatorException(new FacesMessage(err));
        }
    }

    public String login() {
        String outcome;
        block13: {
            outcome = null;
            FacesContext fc = FacesContext.getCurrentInstance();
            if (this.username != null && this.username.length() != 0 && this.password != null && this.password.length() != 0) {
                try {
                    Map session = fc.getExternalContext().getSessionMap();
                    this.getAuthenticationService().authenticate(this.username, this.password.toCharArray());
                    this.username = this.getAuthenticationService().getCurrentUserName();
                    session.remove("_alfSessionInvalid");
                    User user = new User(this.username, this.getAuthenticationService().getCurrentTicket(), this.getPersonService().getPerson(this.username));
                    NodeRef homeSpaceRef = (NodeRef)this.getNodeService().getProperty(this.getPersonService().getPerson(this.username), ContentModel.PROP_HOMEFOLDER);
                    if (homeSpaceRef == null || !this.getNodeService().exists(homeSpaceRef)) {
                        throw new InvalidNodeRefException(homeSpaceRef);
                    }
                    user.setHomeSpaceId(homeSpaceRef.getId());
                    Application.setCurrentUser(fc, user);
                    LoginOutcomeBean loginOutcomeBean = (LoginOutcomeBean)fc.getApplication().createValueBinding("#{LoginOutcomeBean}").getValue(fc);
                    String redirectURL = loginOutcomeBean.getRedirectURL();
                    if (redirectURL != null && redirectURL.length() > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Redirect URL found: " + redirectURL));
                        }
                        try {
                            fc.getExternalContext().redirect(redirectURL);
                            fc.responseComplete();
                            return null;
                        }
                        catch (IOException ioErr) {
                            logger.warn((Object)("Unable to redirect to url: " + redirectURL));
                            break block13;
                        }
                    }
                    this.navigator.initFromClientConfig();
                    if ("myalfresco".equals(this.preferences.getStartLocation())) {
                        return "myalfresco";
                    }
                    return "success";
                }
                catch (AuthenticationDisallowedException aerr) {
                    Utils.addErrorMessage(Application.getMessage(fc, MSG_ERROR_LOGIN_DISALLOWED));
                }
                catch (AuthenticationMaxUsersException aerr) {
                    Utils.addErrorMessage(Application.getMessage(fc, MSG_ERROR_LOGIN_MAXUSERS));
                }
                catch (AuthenticationException aerr) {
                    Utils.addErrorMessage(Application.getMessage(fc, MSG_ERROR_UNKNOWN_USER));
                }
                catch (InvalidNodeRefException refErr) {
                    String msg = refErr.getNodeRef() != null ? refErr.getNodeRef().toString() : Application.getMessage(fc, MSG_NONE);
                    Utils.addErrorMessage(MessageFormat.format(Application.getMessage(fc, "error_homespace"), msg));
                }
            } else {
                Utils.addErrorMessage(Application.getMessage(fc, MSG_ERROR_MISSING));
            }
        }
        return outcome;
    }

    public String logout() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map params = context.getExternalContext().getRequestParameterMap();
        String outcome = (String)params.get(PARAM_OUTCOME);
        if (outcome == null) {
            outcome = OUTCOME_LOGOUT;
        }
        Locale language = Application.getLanguage(context);
        Application.logOut(context);
        Application.setLanguage(context, language.toString());
        return outcome;
    }
}

