/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.web.app.Application;
import org.alfresco.web.config.SidebarConfigElement;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIModeList;
import org.springframework.extensions.config.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SidebarBean
implements Serializable {
    private static final long serialVersionUID = -2613219657864672539L;
    protected String activePlugin;
    protected List<UIListItem> plugins;
    protected SidebarConfigElement sidebarConfig = SidebarBean.getSidebarConfig(FacesContext.getCurrentInstance());

    public SidebarBean() {
        if (this.sidebarConfig == null) {
            throw new IllegalStateException("Failed to find configuration for the sidebar");
        }
        List<UIListItem> items = this.getPlugins();
        if (items.size() == 0) {
            throw new IllegalStateException("Failed to find configuration for any sidebar plugins, at least one must be defined!");
        }
        this.activePlugin = this.sidebarConfig.getDefaultPlugin();
        if (this.activePlugin == null) {
            this.activePlugin = (String)items.get(0).getValue();
        }
    }

    public void pluginChanged(ActionEvent event) {
        UIModeList pluginList = (UIModeList)event.getComponent();
        this.activePlugin = pluginList.getValue().toString();
    }

    public List<UIListItem> getPlugins() {
        if (this.plugins == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.plugins = new ArrayList<UIListItem>();
            for (String pluginId : this.sidebarConfig.getPlugins().keySet()) {
                String tooltip;
                SidebarConfigElement.SidebarPluginConfig plugin = this.sidebarConfig.getPlugin(pluginId);
                String label = plugin.getlabelId();
                if (label != null) {
                    label = Application.getMessage(context, label);
                }
                if (label == null) {
                    label = plugin.getlabel();
                }
                if (label == null) {
                    label = plugin.getId();
                }
                if ((tooltip = plugin.getDescriptionId()) != null) {
                    tooltip = Application.getMessage(context, tooltip);
                }
                if (tooltip == null) {
                    tooltip = plugin.getDescription();
                }
                UIListItem item = new UIListItem();
                item.setValue(plugin.getId());
                item.setLabel(label);
                if (tooltip != null) {
                    item.setTooltip(tooltip);
                }
                this.plugins.add(item);
            }
        }
        return this.plugins;
    }

    public String getActivePlugin() {
        return this.activePlugin;
    }

    public String getActivePluginPage() {
        return this.sidebarConfig.getPlugin(this.activePlugin).getPage();
    }

    public static SidebarConfigElement getSidebarConfig(FacesContext context) {
        SidebarConfigElement config = null;
        Config cfg = Application.getConfigService(context).getConfig((Object)"Sidebar");
        if (cfg != null) {
            config = (SidebarConfigElement)cfg.getConfigElement("sidebar");
        }
        return config;
    }
}

