/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.BaseActionWizard;
import org.alfresco.web.bean.actions.handlers.BaseActionHandler;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.IWizardBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailHandler
extends BaseActionHandler {
    private static final long serialVersionUID = 622475325355334995L;
    public static final String PROP_TO = "to";
    public static final String PROP_FROM = "from";
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_SUBJECT = "subject";
    public static final String PROP_TEMPLATE = "template";

    @Override
    public String getJSPPath() {
        return this.getJSPPath("mail");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        BaseActionWizard wizard = (BaseActionWizard)Application.getWizardManager().getBean();
        List<BaseActionWizard.RecipientWrapper> wizardRecipients = wizard.getEmailRecipients(actionProps);
        ArrayList<String> recipients = new ArrayList<String>(wizardRecipients.size());
        for (int i = 0; i < wizardRecipients.size(); ++i) {
            BaseActionWizard.RecipientWrapper wrapper = wizardRecipients.get(i);
            recipients.add(wrapper.getAuthority());
        }
        repoProps.put("to_many", recipients);
        repoProps.put("text", actionProps.get(PROP_MESSAGE));
        repoProps.put(PROP_SUBJECT, actionProps.get(PROP_SUBJECT));
        String from = Application.getClientConfig(FacesContext.getCurrentInstance()).getFromEmailAddress();
        repoProps.put(PROP_FROM, (Serializable)((Object)from));
        if (wizard.getUsingTemplate() != null) {
            repoProps.put(PROP_TEMPLATE, (Serializable)new NodeRef(Repository.getStoreRef(), wizard.getUsingTemplate()));
        }
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        BaseActionWizard wizard = (BaseActionWizard)Application.getWizardManager().getBean();
        String subject = (String)((Object)repoProps.get(PROP_SUBJECT));
        actionProps.put(PROP_SUBJECT, (Serializable)((Object)subject));
        String message = (String)((Object)repoProps.get("text"));
        actionProps.put(PROP_MESSAGE, (Serializable)((Object)message));
        String to = (String)((Object)repoProps.get(PROP_TO));
        if (to != null) {
            actionProps.put(PROP_TO, (Serializable)((Object)to));
        } else {
            Serializable recipObj = repoProps.get("to_many");
            List<String> recipients = null;
            if (recipObj != null) {
                if (recipObj instanceof String) {
                    recipients = new ArrayList<String>();
                    recipients.add((String)((Object)recipObj));
                } else if (recipObj instanceof List) {
                    recipients = (List)((Object)recipObj);
                }
            }
            if (recipients != null && recipients.size() != 0) {
                for (String authority : recipients) {
                    wizard.getEmailRecipients(actionProps).add(new BaseActionWizard.RecipientWrapper(wizard.displayLabelForAuthority(authority), authority));
                }
            }
        }
        NodeRef templateRef = (NodeRef)repoProps.get(PROP_TEMPLATE);
        if (templateRef != null) {
            actionProps.put(PROP_TEMPLATE, (Serializable)((Object)templateRef.getId()));
            wizard.setUsingTemplate(templateRef.getId());
        }
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> actionProps) {
        List<BaseActionWizard.RecipientWrapper> wizardRecipients;
        BaseActionWizard actionWizard = (BaseActionWizard)wizard;
        String addresses = (String)((Object)actionProps.get(PROP_TO));
        if ((addresses == null || addresses.length() == 0) && (wizardRecipients = actionWizard.getEmailRecipients(actionProps)).size() != 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < wizardRecipients.size(); ++i) {
                BaseActionWizard.RecipientWrapper wrapper = wizardRecipients.get(i);
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(wrapper.getName());
            }
            addresses = builder.toString();
        }
        return MessageFormat.format(Application.getMessage(context, "action_mail"), addresses);
    }
}

