/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ISO9075;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.repository.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminNodeBrowseBean
implements Serializable {
    private static final long serialVersionUID = -8702324672426537379L;
    private String queryLanguage = null;
    private static List<SelectItem> queryLanguages = new ArrayList<SelectItem>();
    private String query = null;
    private SearchResults searchResults = new SearchResults((List<NodeRef>)null);
    private NodeRef nodeRef = null;
    private QName nodeType = null;
    private Path primaryPath = null;
    private Boolean inheritPermissions = null;
    private transient DataModel stores = null;
    private transient DataModel parents = null;
    private transient DataModel aspects = null;
    private transient DataModel properties = null;
    private transient DataModel children = null;
    private transient DataModel assocs = null;
    private transient DataModel permissions = null;
    private transient DataModel permissionMasks = null;
    private transient DataModel avmStoreProps = null;
    private transient TransactionService transactionService;
    private transient NodeService nodeService;
    private transient DictionaryService dictionaryService;
    private transient SearchService searchService;
    private transient NamespaceService namespaceService;
    private transient PermissionService permissionService;
    private transient AVMService avmService;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    private TransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getTransactionService();
        }
        return this.transactionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    private SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    private DictionaryService getDictionaryService() {
        if (this.dictionaryService == null) {
            this.dictionaryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
        }
        return this.dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    private NamespaceService getNamespaceService() {
        if (this.namespaceService == null) {
            this.namespaceService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNamespaceService();
        }
        return this.namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    private PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public void setAVMService(AVMService avmService) {
        this.avmService = avmService;
    }

    private AVMService getAVMService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public DataModel getStores() {
        if (this.stores == null) {
            List storeRefs = this.getNodeService().getStores();
            this.stores = new ListDataModel(storeRefs);
        }
        return this.stores;
    }

    public NodeRef getNodeRef() {
        if (this.nodeRef == null) {
            this.nodeRef = this.getNodeService().getRootNode(new StoreRef("system", "system"));
        }
        return this.nodeRef;
    }

    private void setNodeRef(NodeRef nodeRef) {
        this.nodeRef = nodeRef;
        this.primaryPath = null;
        this.nodeType = null;
        this.parents = null;
        this.aspects = null;
        this.properties = null;
        this.children = null;
        this.assocs = null;
        this.inheritPermissions = null;
        this.permissions = null;
        this.permissionMasks = null;
    }

    public QName getNodeType() {
        if (this.nodeType == null) {
            this.nodeType = this.getNodeService().getType(this.getNodeRef());
        }
        return this.nodeType;
    }

    public String getPrimaryPath() {
        if (this.primaryPath == null) {
            this.primaryPath = this.getNodeService().getPath(this.getNodeRef());
        }
        return ISO9075.decode((String)this.primaryPath.toString());
    }

    public NodeRef getPrimaryParent() {
        this.getPrimaryPath();
        Path.Element element = this.primaryPath.last();
        NodeRef parentRef = ((Path.ChildAssocElement)element).getRef().getParentRef();
        return parentRef;
    }

    public DataModel getAspects() {
        if (this.aspects == null) {
            ArrayList aspectNames = new ArrayList(this.getNodeService().getAspects(this.getNodeRef()));
            this.aspects = new ListDataModel(aspectNames);
        }
        return this.aspects;
    }

    public DataModel getParents() {
        if (this.parents == null) {
            List parentRefs = this.getNodeService().getParentAssocs(this.getNodeRef());
            this.parents = new ListDataModel(parentRefs);
        }
        return this.parents;
    }

    public DataModel getProperties() {
        if (this.properties == null) {
            Map propertyValues = this.getNodeService().getProperties(this.getNodeRef());
            ArrayList<Property> nodeProperties = new ArrayList<Property>(propertyValues.size());
            for (Map.Entry property : propertyValues.entrySet()) {
                nodeProperties.add(new Property((QName)property.getKey(), (Serializable)property.getValue()));
            }
            this.properties = new ListDataModel(nodeProperties);
        }
        return this.properties;
    }

    public boolean getInheritPermissions() {
        if (this.inheritPermissions == null) {
            this.inheritPermissions = this.getPermissionService().getInheritParentPermissions(this.nodeRef);
        }
        return this.inheritPermissions;
    }

    public DataModel getPermissions() {
        if (this.permissions == null) {
            AccessStatus readPermissions = this.getPermissionService().hasPermission(this.nodeRef, "ReadPermissions");
            if (readPermissions.equals((Object)AccessStatus.ALLOWED)) {
                ArrayList nodePermissions = new ArrayList(this.getPermissionService().getAllSetPermissions(this.nodeRef));
                this.permissions = new ListDataModel(nodePermissions);
            } else {
                ArrayList<NoReadPermissionGranted> noReadPermissions = new ArrayList<NoReadPermissionGranted>(1);
                noReadPermissions.add(new NoReadPermissionGranted());
                this.permissions = new ListDataModel(noReadPermissions);
            }
        }
        return this.permissions;
    }

    public DataModel getStorePermissionMasks() {
        if (this.permissionMasks == null) {
            if (this.nodeRef.getStoreRef().getProtocol().equals("avm")) {
                ArrayList nodePermissions = new ArrayList(this.getPermissionService().getAllSetPermissions(this.nodeRef.getStoreRef()));
                this.permissionMasks = new ListDataModel(nodePermissions);
            } else {
                ArrayList<NoStoreMask> noReadPermissions = new ArrayList<NoStoreMask>(1);
                noReadPermissions.add(new NoStoreMask());
                this.permissionMasks = new ListDataModel(noReadPermissions);
            }
        }
        return this.permissionMasks;
    }

    public DataModel getChildren() {
        if (this.children == null) {
            List assocRefs = this.getNodeService().getChildAssocs(this.getNodeRef());
            this.children = new ListDataModel(assocRefs);
        }
        return this.children;
    }

    public DataModel getAssocs() {
        if (this.assocs == null) {
            try {
                List assocRefs = this.getNodeService().getTargetAssocs(this.getNodeRef(), RegexQNamePattern.MATCH_ALL);
                this.assocs = new ListDataModel(assocRefs);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return this.assocs;
    }

    public boolean getInAVMStore() {
        return this.nodeRef.getStoreRef().getProtocol().equals("avm");
    }

    public DataModel getAVMStoreProperties() {
        if (this.avmStoreProps == null) {
            String store = this.nodeRef.getStoreRef().getIdentifier();
            Map props = this.getAVMService().getStoreProperties(store);
            ArrayList storeProperties = new ArrayList();
            for (Map.Entry property : props.entrySet()) {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("name", ((QName)property.getKey()).toString());
                map.put("type", ((PropertyValue)property.getValue()).getActualTypeString());
                String val = ((PropertyValue)property.getValue()).getStringValue();
                if (val == null) {
                    val = "null";
                }
                map.put("value", val);
                storeProperties.add(map);
            }
            this.avmStoreProps = new ListDataModel(storeProperties);
        }
        return this.avmStoreProps;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setQueryLanguage(String queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<SelectItem> getQueryLanguages() {
        return queryLanguages;
    }

    public SearchResults getSearchResults() {
        return this.searchResults;
    }

    public String selectStore() {
        StoreRef storeRef = (StoreRef)this.getStores().getRowData();
        NodeRef rootNode = this.getNodeService().getRootNode(storeRef);
        this.setNodeRef(rootNode);
        this.avmStoreProps = null;
        return "success";
    }

    public String selectStores() {
        this.stores = null;
        return "success";
    }

    public String selectPrimaryPath() {
        this.setNodeRef(this.nodeRef);
        return "success";
    }

    public String selectPrimaryParent() {
        this.setNodeRef(this.getPrimaryParent());
        return "success";
    }

    public String selectParent() {
        ChildAssociationRef assocRef = (ChildAssociationRef)this.getParents().getRowData();
        NodeRef parentRef = assocRef.getParentRef();
        this.setNodeRef(parentRef);
        return "success";
    }

    public String selectToNode() {
        AssociationRef assocRef = (AssociationRef)this.getAssocs().getRowData();
        NodeRef targetRef = assocRef.getTargetRef();
        this.setNodeRef(targetRef);
        return "success";
    }

    public String selectNodeProperty() {
        Property property = (Property)this.getProperties().getRowData();
        Property.Value value = (Property.Value)property.getValues().getRowData();
        NodeRef nodeRef = (NodeRef)value.getValue();
        this.setNodeRef(nodeRef);
        return "success";
    }

    public String selectChild() {
        ChildAssociationRef assocRef = (ChildAssociationRef)this.getChildren().getRowData();
        NodeRef childRef = assocRef.getChildRef();
        this.setNodeRef(childRef);
        return "success";
    }

    public String selectResultNode() {
        ChildAssociationRef assocRef = (ChildAssociationRef)this.searchResults.getRows().getRowData();
        NodeRef childRef = assocRef.getChildRef();
        this.setNodeRef(childRef);
        return "success";
    }

    public String submitSearch() {
        RetryingTransactionHelper.RetryingTransactionCallback<String> searchCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                if (AdminNodeBrowseBean.this.queryLanguage.equals("noderef")) {
                    NodeRef nodeRef = new NodeRef(AdminNodeBrowseBean.this.query);
                    boolean exists = AdminNodeBrowseBean.this.getNodeService().exists(nodeRef);
                    if (!exists) {
                        throw new AlfrescoRuntimeException("Node " + nodeRef + " does not exist.");
                    }
                    AdminNodeBrowseBean.this.setNodeRef(nodeRef);
                    return "node";
                }
                if (AdminNodeBrowseBean.this.queryLanguage.equals("selectnodes")) {
                    List nodes = AdminNodeBrowseBean.this.getSearchService().selectNodes(AdminNodeBrowseBean.this.getNodeRef(), AdminNodeBrowseBean.this.query, null, (NamespacePrefixResolver)AdminNodeBrowseBean.this.getNamespaceService(), false);
                    AdminNodeBrowseBean.this.searchResults = new SearchResults(nodes);
                    return "search";
                }
                AdminNodeBrowseBean.this.searchResults = new SearchResults(AdminNodeBrowseBean.this.getSearchService().query(AdminNodeBrowseBean.this.getNodeRef().getStoreRef(), AdminNodeBrowseBean.this.queryLanguage, AdminNodeBrowseBean.this.query));
                return "search";
            }
        };
        try {
            return (String)this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)searchCallback, true);
        }
        catch (Throwable e) {
            FacesContext context = FacesContext.getCurrentInstance();
            FacesMessage message = new FacesMessage();
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            message.setDetail("Search failed due to: " + e.toString());
            context.addMessage("searchForm:query", message);
            return "error";
        }
    }

    static {
        queryLanguages.add(new SelectItem((Object)"noderef"));
        queryLanguages.add(new SelectItem((Object)"xpath"));
        queryLanguages.add(new SelectItem((Object)"lucene"));
        queryLanguages.add(new SelectItem((Object)"fts-alfresco"));
        queryLanguages.add(new SelectItem((Object)"cmis-strict"));
        queryLanguages.add(new SelectItem((Object)"cmis-alfresco"));
        queryLanguages.add(new SelectItem((Object)"selectnodes"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SearchResults
    implements Serializable {
        private static final long serialVersionUID = 7402906720039176001L;
        private int length = 0;
        private SerialListDataModel rows = new SerialListDataModel();

        public SearchResults(ResultSet resultSet) {
            if (resultSet != null) {
                this.rows.setWrappedData(resultSet.getChildAssocRefs());
                this.length = resultSet.length();
                resultSet.close();
            }
        }

        public SearchResults(List<NodeRef> resultSet) {
            if (resultSet != null) {
                ArrayList<ChildAssociationRef> assocRefs = new ArrayList<ChildAssociationRef>(resultSet.size());
                for (NodeRef nodeRef : resultSet) {
                    ChildAssociationRef childAssocRef = AdminNodeBrowseBean.this.getNodeService().getPrimaryParent(nodeRef);
                    assocRefs.add(childAssocRef);
                }
                this.rows.setWrappedData(assocRefs);
                this.length = resultSet.size();
            }
        }

        public int getLength() {
            return this.length;
        }

        public DataModel getRows() {
            return this.rows;
        }

        private class SerialListDataModel
        extends ListDataModel
        implements Serializable {
            private static final long serialVersionUID = 4154583769762846020L;

            private SerialListDataModel() {
            }
        }
    }

    public static class NoStoreMask
    implements Serializable {
        private static final long serialVersionUID = -6256369557521402921L;

        public String getPermission() {
            return "All <No Mask>";
        }

        public String getAuthority() {
            return "All";
        }

        public String getAccessStatus() {
            return "Allowed";
        }
    }

    public static class NoReadPermissionGranted
    implements Serializable {
        private static final long serialVersionUID = -6256369557521402921L;

        public String getPermission() {
            return "ReadPermissions";
        }

        public String getAuthority() {
            return "[Current Authority]";
        }

        public String getAccessStatus() {
            return "Not Granted";
        }
    }

    public class Property {
        private QName name;
        private boolean isCollection = false;
        private DataModel values;
        private String datatype;
        private String residual;

        public Property(QName name, Serializable value) {
            List<Value> values;
            this.name = name;
            PropertyDefinition propDef = AdminNodeBrowseBean.this.getDictionaryService().getProperty(name);
            if (propDef != null) {
                this.datatype = propDef.getDataType().getName().toString();
                this.residual = "false";
            } else {
                this.residual = "true";
            }
            if (value instanceof Collection) {
                Collection oldValues = (Collection)((Object)value);
                values = new ArrayList<Value>(oldValues.size());
                this.isCollection = true;
                for (Serializable multiValue : oldValues) {
                    values.add(new Value(multiValue));
                }
            } else {
                values = Collections.singletonList(new Value(value));
            }
            this.values = new ListDataModel(values);
        }

        public QName getName() {
            return this.name;
        }

        public String getDataType() {
            return this.datatype;
        }

        public DataModel getValues() {
            return this.values;
        }

        public String getResidual() {
            return this.residual;
        }

        public boolean isAny() {
            return this.datatype == null ? false : this.datatype.equals(DataTypeDefinition.ANY.toString());
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public class Value {
            private Serializable value;

            public Value(Serializable value) {
                this.value = value;
            }

            public Serializable getValue() {
                return this.value;
            }

            public String getDataType() {
                DataTypeDefinition dataTypeDefinition;
                String datatype = Property.this.getDataType();
                if ((datatype == null || datatype.equals(DataTypeDefinition.ANY.toString())) && this.value != null && (dataTypeDefinition = AdminNodeBrowseBean.this.getDictionaryService().getDataType(this.value.getClass())) != null) {
                    datatype = AdminNodeBrowseBean.this.getDictionaryService().getDataType(this.value.getClass()).getName().toString();
                }
                return datatype;
            }

            public String getUrl() {
                String url = FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath();
                url = url + DownloadContentServlet.generateBrowserURL(AdminNodeBrowseBean.this.nodeRef, "file.bin");
                url = url + "?property=" + Property.this.name;
                return url;
            }

            public boolean isContent() {
                String datatype = this.getDataType();
                return datatype == null ? false : datatype.equals(DataTypeDefinition.CONTENT.toString());
            }

            public boolean isNodeRef() {
                String datatype = this.getDataType();
                return datatype == null ? false : datatype.equals(DataTypeDefinition.NODE_REF.toString()) || datatype.equals(DataTypeDefinition.CATEGORY.toString());
            }

            public boolean isNullValue() {
                return this.value == null;
            }
        }
    }
}

