/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.categories;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.dialog.ChangeViewSupport;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIBreadcrumb;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.alfresco.web.ui.repo.component.IRepoBreadcrumbHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoriesDialog
extends BaseDialogBean
implements IContextListener,
ChangeViewSupport {
    private static final long serialVersionUID = -1254971127977205987L;
    public static final String KEY_CATEGORY = "category";
    public static final String PARAM_CATEGORY_REF = "categoryRef";
    private static final String VIEW_ICONS = "icons";
    private static final String VIEW_DETAILS = "details";
    private static final String LABEL_VIEW_ICONS = "category_icons";
    private static final String LABEL_VIEW_DETAILS = "category_details";
    private static final String MSG_CLOSE = "close";
    private transient CategoryService categoryService;
    private Collection<ChildAssociationRef> members = null;
    private Node category = null;
    private NodeRef categoryRef = null;
    private Node actionCategory = null;
    private String viewMode = "icons";
    protected UIRichList categoriesRichList;
    private List<IBreadcrumbHandler> location = null;
    private static final String MSG_CATEGORIES = "categories";
    private String name = null;
    private String description = null;
    private static Log logger = LogFactory.getLog(CategoriesDialog.class);

    public CategoriesDialog() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
    }

    public int getMembersCount() {
        return this.getMembers() != null ? this.getMembers().size() : 0;
    }

    public Collection<ChildAssociationRef> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<ChildAssociationRef> members) {
        this.members = members;
    }

    public Node getActionCategory() {
        return this.actionCategory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.getCurrentCategoryId();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CategoryService getCategoryService() {
        if (this.categoryService == null) {
            this.categoryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCategoryService();
        }
        return this.categoryService;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public Node getCategory() {
        return this.category;
    }

    public void setCategory(Node category) {
        this.category = category;
    }

    public NodeRef getCategoryRef() {
        return this.categoryRef;
    }

    public void setCategoryRef(NodeRef categoryRef) {
        this.categoryRef = categoryRef;
    }

    public UIRichList getCategoriesRichList() {
        return this.categoriesRichList;
    }

    public void setCategoriesRichList(UIRichList categoriesRichList) {
        this.categoriesRichList = categoriesRichList;
    }

    @Override
    public Object getActionsContext() {
        return this;
    }

    public void setActionCategory(Node node) {
        this.actionCategory = node;
        if (node != null) {
            this.setName(node.getName());
            this.setDescription((String)node.getProperties().get(ContentModel.PROP_DESCRIPTION));
            this.setMembers(this.getCategoryService().getChildren(node.getNodeRef(), CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY));
        } else {
            this.setName(null);
            this.setDescription(null);
            List emptyCollection = Collections.emptyList();
            this.setMembers(emptyCollection);
        }
    }

    public Node getCurrentCategory() {
        if (this.getCategory() == null && this.getCategoryRef() != null) {
            this.setCategory(new Node(this.getCategoryRef()));
        }
        return this.getCategory();
    }

    public String getCurrentCategoryId() {
        if (this.getCategoryRef() != null) {
            return this.getCategoryRef().getId();
        }
        return null;
    }

    public void setCurrentCategory(NodeRef ref) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting current category: " + ref));
        }
        this.setCategoryRef(ref);
        this.setCategory(null);
        this.contextUpdated();
    }

    public void setLocation(List<IBreadcrumbHandler> location) {
        this.location = location;
    }

    public List<IBreadcrumbHandler> getLocation() {
        if (this.location == null) {
            ArrayList<IBreadcrumbHandler> loc = new ArrayList<IBreadcrumbHandler>(8);
            loc.add(new CategoryBreadcrumbHandler(null, Application.getMessage(FacesContext.getCurrentInstance(), MSG_CATEGORIES)));
            this.setLocation(loc);
        }
        return this.location;
    }

    public List<Node> getCategories() {
        List<Node> categories;
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            Collection refs = this.getCategoryRef() == null ? this.getCategoryService().getCategories(Repository.getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE, CategoryService.Depth.IMMEDIATE) : this.getCategoryService().getChildren(this.getCategoryRef(), CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE);
            categories = new ArrayList<Node>(refs.size());
            for (ChildAssociationRef child : refs) {
                Node categoryNode = new Node(child.getChildRef());
                categoryNode.getProperties();
                categories.add(categoryNode);
            }
            tx.commit();
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), refErr.getNodeRef()));
            categories = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {}
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            categories = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        return categories;
    }

    public void setupCategoryAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setup for action, setting current Category to: " + id));
            }
            try {
                NodeRef ref = new NodeRef(Repository.getStoreRef(), id);
                Node node = new Node(ref);
                this.setActionCategory(node);
                this.contextUpdated();
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
            }
        }
    }

    public void clearCategoryAction(ActionEvent event) {
        this.setActionCategory(null);
        this.contextUpdated();
    }

    public void resetCategoryNavigation(ActionEvent event) {
        this.setCurrentCategory(null);
        this.location = null;
    }

    public void clickCategory(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            try {
                NodeRef ref = new NodeRef(Repository.getStoreRef(), id);
                this.updateUILocation(ref);
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
            }
        }
    }

    private void updateUILocation(NodeRef ref) {
        String name = Repository.getNameForNode(this.getNodeService(), ref);
        this.getLocation().add(new CategoryBreadcrumbHandler(ref, name));
        this.setCurrentCategory(ref);
    }

    protected void removeFromBreadcrumb(String category) {
        List<IBreadcrumbHandler> location = this.getLocation();
        CategoryBreadcrumbHandler handler = (CategoryBreadcrumbHandler)location.get(location.size() - 1);
        if (category.equals(handler.label)) {
            location.remove(location.size() - 1);
            if (location.size() != 0) {
                handler = (CategoryBreadcrumbHandler)location.get(location.size() - 1);
                this.setCurrentCategory(handler.nodeRef);
            }
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public String getContainerSubTitle() {
        if (this.getCurrentCategoryId() != null) {
            return this.getCurrentCategory().getName();
        }
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CATEGORIES);
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    @Override
    public void contextUpdated() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Invalidating Category Management Components...");
        }
        this.setCategory(null);
        if (this.categoriesRichList != null) {
            this.categoriesRichList.setValue(null);
        }
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    @Override
    public List<UIListItem> getViewItems() {
        FacesContext context = FacesContext.getCurrentInstance();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(2);
        UIListItem item1 = new UIListItem();
        item1.setValue(VIEW_ICONS);
        item1.setLabel(Application.getMessage(context, LABEL_VIEW_ICONS));
        items.add(item1);
        UIListItem item2 = new UIListItem();
        item2.setValue(VIEW_DETAILS);
        item2.setLabel(Application.getMessage(context, LABEL_VIEW_DETAILS));
        items.add(item2);
        return items;
    }

    @Override
    public void restored() {
        Object categoryToRemove = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(KEY_CATEGORY);
        if (categoryToRemove != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing group '" + categoryToRemove + "' from breadcrumb"));
            }
            this.removeFromBreadcrumb((String)categoryToRemove);
        }
        this.contextUpdated();
    }

    @Override
    public String getViewMode() {
        return this.viewMode;
    }

    @Override
    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
    }

    @Override
    public void viewModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        this.setViewMode(viewList.getValue().toString());
    }

    @Override
    public String getMoreActionsConfigId() {
        if (this.getCurrentCategoryId() != null) {
            return "category_more_actions";
        }
        return null;
    }

    public NodeRef getNodeRef() {
        return this.getCurrentCategory().getNodeRef();
    }

    public class CategoryBreadcrumbHandler
    implements IRepoBreadcrumbHandler {
        private static final long serialVersionUID = 3831234653171036630L;
        private NodeRef nodeRef;
        private String label;

        public CategoryBreadcrumbHandler(NodeRef nodeRef, String label) {
            this.label = label;
            this.nodeRef = nodeRef;
        }

        public String toString() {
            return this.label;
        }

        public String navigationOutcome(UIBreadcrumb breadcrumb) {
            CategoriesDialog.this.setCurrentCategory(this.nodeRef);
            CategoriesDialog.this.setLocation((List)breadcrumb.getValue());
            return null;
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }
    }
}

