/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.categories;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCategoryDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 1905920932992642119L;
    private static final String DEFAULT_OUTCOME = "finish";
    protected transient CategoryService categoryService;
    private NodeRef categoryRef = null;
    private String name = null;
    private String description = null;

    @Override
    public void init(Map<String, String> parameters) {
        this.isFinished = false;
        String ref = parameters.get("categoryRef");
        this.name = null;
        this.description = null;
        this.categoryRef = ref != null ? new NodeRef(ref) : null;
    }

    private CategoryService getCategoryService() {
        if (this.categoryService == null) {
            this.categoryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCategoryService();
        }
        return this.categoryService;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public NodeRef getCategoryRef() {
        return this.categoryRef;
    }

    public void setCategoryRef(NodeRef categoryRef) {
        this.categoryRef = categoryRef;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.finishCreate();
        return outcome;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "new_category");
    }

    public String finishCreate() {
        String outcome = DEFAULT_OUTCOME;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(context);
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    NodeRef ref = CreateCategoryDialog.this.getCategoryRef() == null || CreateCategoryDialog.this.getCategoryRef().getId().equals("null") ? CreateCategoryDialog.this.getCategoryService().createRootCategory(Repository.getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE, CreateCategoryDialog.this.getName()) : CreateCategoryDialog.this.getCategoryService().createCategory(CreateCategoryDialog.this.getCategoryRef(), CreateCategoryDialog.this.getName());
                    HashMap<QName, String> titledProps = new HashMap<QName, String>(1, 1.0f);
                    titledProps.put(ContentModel.PROP_DESCRIPTION, CreateCategoryDialog.this.getDescription());
                    CreateCategoryDialog.this.getNodeService().addAspect(ref, ContentModel.ASPECT_TITLED, titledProps);
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            outcome = null;
            ReportedException.throwIfNecessary(err);
        }
        return outcome;
    }
}

