/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.clipboard;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.faces.context.FacesContext;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.clipboard.ClipboardBean;
import org.alfresco.web.bean.clipboard.ClipboardItem;
import org.alfresco.web.bean.clipboard.ClipboardStatus;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractClipboardItem
implements ClipboardItem {
    protected static Log logger = LogFactory.getLog(ClipboardBean.class);
    protected static final String MSG_COPY_OF = "copy_of";
    private static final String XPATH_QUERY_NODE_MATCH = "./*[like(@cm:name, $cm:name, false)]";
    private transient ServiceRegistry services = null;
    protected NodeRef ref;
    protected ClipboardStatus mode;
    private String name;
    private QName type;
    private String icon;
    protected transient AVMService avmService;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = this.getServiceRegistry().getAVMLockingAwareService();
        }
        return this.avmService;
    }

    public AbstractClipboardItem(NodeRef ref, ClipboardStatus mode) {
        this.ref = ref;
        this.mode = mode;
    }

    public ClipboardStatus getMode() {
        return this.mode;
    }

    public String getName() {
        if (this.name == null) {
            this.name = (String)((Object)this.getServiceRegistry().getNodeService().getProperty(this.ref, ContentModel.PROP_NAME));
        }
        return this.name;
    }

    public QName getType() {
        if (this.type == null) {
            this.type = this.getServiceRegistry().getNodeService().getType(this.ref);
        }
        return this.type;
    }

    public String getIcon() {
        if (this.icon == null) {
            this.icon = (String)((Object)this.getServiceRegistry().getNodeService().getProperty(this.ref, ApplicationModel.PROP_ICON));
        }
        return this.icon;
    }

    public NodeRef getNodeRef() {
        return this.ref;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClipboardItem) {
            return ((ClipboardItem)obj).getNodeRef().equals((Object)this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    protected ServiceRegistry getServiceRegistry() {
        if (this.services == null) {
            this.services = Repository.getServiceRegistry(FacesContext.getCurrentInstance());
        }
        return this.services;
    }

    protected boolean checkExists(String name, NodeRef parent) {
        QueryParameterDefinition[] params = new QueryParameterDefinition[]{new QueryParameterDefImpl(ContentModel.PROP_NAME, this.getServiceRegistry().getDictionaryService().getDataType(DataTypeDefinition.TEXT), true, name)};
        List nodeRefs = this.getServiceRegistry().getSearchService().selectNodes(parent, XPATH_QUERY_NODE_MATCH, params, (NamespacePrefixResolver)this.getServiceRegistry().getNamespaceService(), false);
        return nodeRefs.size() != 0;
    }

    protected void recursiveFormCheck(AVMNodeDescriptor desc) {
        if (desc.isFile()) {
            String filePath = desc.getPath();
            if (this.avmService.hasAspect(-1, filePath, WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
                this.avmService.removeAspect(filePath, WCMAppModel.ASPECT_FORM_INSTANCE_DATA);
            }
            if (this.avmService.hasAspect(-1, filePath, WCMAppModel.ASPECT_RENDITION)) {
                this.avmService.removeAspect(filePath, WCMAppModel.ASPECT_RENDITION);
            }
        } else {
            SortedMap listing = this.getAvmService().getDirectoryListing(desc);
            for (Map.Entry entry : listing.entrySet()) {
                this.recursiveFormCheck((AVMNodeDescriptor)entry.getValue());
            }
        }
    }
}

