/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.coci;

import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.coci.CheckinCheckoutDialog;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CCCheckoutFileDialog
extends CheckinCheckoutDialog {
    private static final long serialVersionUID = 1137163500648349730L;
    public static final String LBL_SAVE = "save";
    public static final String LBL_CHECKOUT = "check_out";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private static Log logger = LogFactory.getLog(CCCheckoutFileDialog.class);

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return this.checkoutFile(context, outcome);
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), LBL_CHECKOUT);
    }

    public String getContainerTitle() {
        Node document = this.property.getDocument();
        if (document != null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            return Application.getMessage(fc, LBL_CHECKOUT) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + document.getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
        }
        return null;
    }

    public String checkoutFile(FacesContext context, String outcome) {
        boolean checkoutSuccessful = false;
        Node node = this.property.getDocument();
        if (node != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to checkout content node Id: " + node.getId()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Checkout copy location: " + this.property.getCopyLocation()));
                    logger.debug((Object)("Selected Space Id: " + this.property.getSelectedSpaceId()));
                }
                NodeRef workingCopyRef = null;
                if (this.property.getCopyLocation().equals("other") && this.property.getSelectedSpaceId() != null) {
                    NodeRef destRef = this.property.getSelectedSpaceId();
                    ChildAssociationRef childAssocRef = this.getNodeService().getPrimaryParent(destRef);
                    workingCopyRef = this.property.getVersionOperationsService().checkout(node.getNodeRef(), destRef, ContentModel.ASSOC_CONTAINS, childAssocRef.getQName());
                } else {
                    NodeRef workflowPackage;
                    WorkflowTask task;
                    workingCopyRef = this.property.getVersionOperationsService().checkout(node.getNodeRef());
                    if (this.property.isWorkflowAction() && this.property.getWorkflowTaskId() != null && !this.property.getWorkflowTaskId().equals("null") && (task = this.property.getWorkflowService().getTaskById(this.property.getWorkflowTaskId())) != null && (workflowPackage = (NodeRef)task.properties.get(WorkflowModel.ASSOC_PACKAGE)) != null) {
                        this.getNodeService().addChild(workflowPackage, workingCopyRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)((String)((Object)this.getNodeService().getProperty(workingCopyRef, ContentModel.PROP_NAME))))));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Added working copy to workflow package: " + workflowPackage));
                        }
                    }
                }
                Node workingCopy = new Node(workingCopyRef);
                this.property.setWorkingDocument(workingCopy);
                String url = DownloadContentServlet.generateDownloadURL(workingCopyRef, workingCopy.getName());
                workingCopy.getProperties().put("url", url);
                workingCopy.getProperties().put("fileType32", FileTypeImageUtils.getFileTypeImage((String)workingCopy.getName(), (boolean)false));
                checkoutSuccessful = true;
            }
            catch (Throwable err) {
                Utils.addErrorMessage(Application.getMessage(context, "error_checkout") + err.getMessage(), err);
                ReportedException.throwIfNecessary(err);
            }
        } else {
            logger.warn((Object)"WARNING: checkoutFile called without a current Document!");
        }
        if (checkoutSuccessful) {
            outcome = this.getNodeService().exists(this.property.getWorkingDocument().getNodeRef()) ? "dialog:checkoutFileLink" : "dialog:workingCopyMissing";
        }
        return outcome;
    }
}

