/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.content.BaseContentWizard;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormProcessor;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.XMLUtil;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateContentWizard
extends BaseContentWizard {
    private static final long serialVersionUID = -2740634368271194418L;
    protected String content = null;
    protected List<SelectItem> createMimeTypes;
    protected transient FormsService formsService;
    protected String formName;
    protected FormProcessor.Session formProcessorSession = null;
    protected transient Document instanceDataDocument = null;
    private static Log logger = LogFactory.getLog(CreateContentWizard.class);

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    private FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    @Override
    public String finish() {
        if (this.instanceDataDocument != null) {
            this.content = XMLUtil.toString(this.instanceDataDocument, true);
            this.mimeType = "text/xml";
        }
        String result = super.finish();
        if (this.createdNode != null && this.instanceDataDocument != null) {
            HashMap<QName, String> props = new HashMap<QName, String>(1, 1.0f);
            props.put(WCMAppModel.PROP_PARENT_FORM_NAME, this.getFormName());
            props.put(WCMAppModel.PROP_ORIGINAL_PARENT_PATH, "");
            this.getNodeService().addAspect(this.createdNode, WCMAppModel.ASPECT_FORM_INSTANCE_DATA, props);
        }
        return result;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.saveContent(null, this.content);
        return outcome;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.content = null;
        this.inlineEdit = true;
        this.mimeType = "text/html";
        this.formName = "";
        this.instanceDataDocument = null;
        if (this.formProcessorSession != null) {
            this.formProcessorSession.destroy();
        }
        this.formProcessorSession = null;
    }

    @Override
    public boolean getNextButtonDisabled() {
        boolean disabled = false;
        int step = Application.getWizardManager().getCurrentStep();
        switch (step) {
            case 1: {
                disabled = this.fileName == null || this.fileName.length() == 0;
            }
        }
        return disabled;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        boolean disabled = false;
        int step = Application.getWizardManager().getCurrentStep();
        switch (step) {
            case 1: {
                disabled = this.fileName == null || this.fileName.length() == 0;
            }
        }
        return disabled;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        if (this.showOtherProperties) {
            this.browseBean.setDocument(new Node(this.createdNode));
            return this.getDefaultFinishOutcome() + ":" + "dialog:setContentProperties";
        }
        return outcome;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<SelectItem> getCreateMimeTypes() {
        if (this.createMimeTypes == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.createMimeTypes = new ArrayList<SelectItem>(5);
            ConfigService svc = Application.getConfigService(context);
            Config wizardCfg = svc.getConfig((Object)"Content Wizards");
            if (wizardCfg != null) {
                ConfigElement typesCfg = wizardCfg.getConfigElement("create-mime-types");
                if (typesCfg != null) {
                    for (ConfigElement child : typesCfg.getChildren()) {
                        String currentMimeType = child.getAttribute("name");
                        if (currentMimeType == null) continue;
                        String label = this.getSummaryMimeType(currentMimeType);
                        this.createMimeTypes.add(new SelectItem((Object)currentMimeType, label));
                    }
                    QuickSort sorter = new QuickSort(this.objectTypes, "label", true, "case-insensitive");
                    sorter.sort();
                } else {
                    logger.warn((Object)"Could not find 'create-mime-types' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Content Wizards' configuration section");
            }
        }
        return this.createMimeTypes;
    }

    public String getSummary() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        if (this.instanceDataDocument != null) {
            this.mimeType = "text/xml";
        }
        return this.buildSummary(new String[]{bundle.getString("file_name"), bundle.getString("type"), bundle.getString("content_type")}, new String[]{Utils.encode((String)this.fileName), this.getSummaryObjectType(), this.getSummaryMimeType(this.mimeType)});
    }

    public List<SelectItem> getFormsList() {
        Collection<Form> forms = this.getFormsService().getForms();
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(forms.size() + 1);
        items.add(new SelectItem((Object)"", ""));
        for (Form form : forms) {
            items.add(new SelectItem((Object)form.getName(), form.getTitle()));
        }
        return items;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Form getForm() throws FormNotFoundException {
        return this.getFormName() != null ? this.getFormsService().getForm(this.formName) : null;
    }

    public FormProcessor.Session getFormProcessorSession() {
        return this.formProcessorSession;
    }

    public void setFormProcessorSession(FormProcessor.Session formProcessorSession) {
        this.formProcessorSession = formProcessorSession;
    }

    public Document getInstanceDataDocument() {
        if (this.instanceDataDocument == null) {
            String content = this.getContent();
            try {
                this.instanceDataDocument = content != null ? XMLUtil.parse(content) : XMLUtil.newDocument();
            }
            catch (Exception e) {
                Utils.addErrorMessage("error parsing document", e);
                this.instanceDataDocument = XMLUtil.newDocument();
            }
        }
        return this.instanceDataDocument;
    }

    @Override
    public String getFileName() {
        String result = super.getFileName();
        return result != null && "text/xml".equals(this.mimeType) && this.getFormName() != null && "xml".equals(FilenameUtils.getExtension((String)result).toLowerCase()) ? FilenameUtils.removeExtension((String)result) : result;
    }

    public void createContentChanged(ValueChangeEvent event) {
        this.content = null;
    }

    @Override
    protected String formatErrorMessage(Throwable exception) {
        if (exception instanceof FileExistsException) {
            return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_exists"), ((FileExistsException)exception).getName());
        }
        return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_content"), exception.getMessage());
    }
}

