/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditContentPropertiesDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -5681296528149487178L;
    protected static final String TEMP_PROP_MIMETYPE = "mimetype";
    protected static final String TEMP_PROP_ENCODING = "encoding";
    protected Node editableNode;

    @Override
    public void init(Map<String, String> parameters) {
        ContentData content;
        super.init(parameters);
        this.editableNode = this.initEditableNode();
        if (this.editableNode != null && (content = (ContentData)this.editableNode.getProperties().get(ContentModel.PROP_CONTENT)) != null) {
            this.editableNode.getProperties().put(TEMP_PROP_MIMETYPE, content.getMimetype());
            this.editableNode.getProperties().put(TEMP_PROP_ENCODING, content.getEncoding());
        }
    }

    protected Node initEditableNode() {
        Node document = this.browseBean.getDocument();
        if (document != null) {
            return new Node(document.getNodeRef());
        }
        return null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        String encoding;
        NodeRef nodeRef = this.editableNode.getNodeRef();
        Map<String, Object> editedProps = this.editableNode.getProperties();
        String name = (String)editedProps.get(ContentModel.PROP_NAME);
        if (name != null) {
            this.getFileFolderService().rename(nodeRef, name);
        }
        Map repoProps = this.getNodeService().getProperties(nodeRef);
        String mimetype = (String)editedProps.get(TEMP_PROP_MIMETYPE);
        if (mimetype != null) {
            editedProps.remove(TEMP_PROP_MIMETYPE);
            ContentData contentData = (ContentData)editedProps.get(ContentModel.PROP_CONTENT);
            if (contentData != null) {
                contentData = ContentData.setMimetype((ContentData)contentData, (String)mimetype);
                editedProps.put(ContentModel.PROP_CONTENT.toString(), contentData);
            }
        }
        if ((encoding = (String)editedProps.get(TEMP_PROP_ENCODING)) != null) {
            editedProps.remove(TEMP_PROP_ENCODING);
            ContentData contentData = (ContentData)editedProps.get(ContentModel.PROP_CONTENT);
            if (contentData != null) {
                contentData = ContentData.setEncoding((ContentData)contentData, (String)encoding);
                editedProps.put(ContentModel.PROP_CONTENT.toString(), contentData);
            }
        }
        if (!this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_AUTHOR)) {
            this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_AUTHOR, null);
        }
        if (!this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_TITLED)) {
            this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_TITLED, null);
        }
        for (String propName : editedProps.keySet()) {
            QName qname = QName.createQName((String)propName);
            Serializable propValue = (Serializable)editedProps.get(propName);
            if (propValue instanceof String) {
                PropertyDefinition propDef = this.getDictionaryService().getProperty(qname);
                if (((String)((Object)propValue)).length() == 0) {
                    if (propDef != null && (propDef.getDataType().getName().equals((Object)DataTypeDefinition.DOUBLE) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.FLOAT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.INT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.LONG))) {
                        propValue = null;
                    }
                } else if (propDef != null && propDef.getDataType().getName().equals((Object)DataTypeDefinition.LOCALE)) {
                    propValue = I18NUtil.parseLocale((String)((String)((Object)propValue)));
                }
            }
            repoProps.put(qname, propValue);
        }
        this.getNodeService().setProperties(nodeRef, repoProps);
        Map<String, Map<String, AssociationRef>> addedAssocs = this.editableNode.getAddedAssociations();
        for (Map<String, AssociationRef> typedAssoc : addedAssocs.values()) {
            for (AssociationRef associationRef : typedAssoc.values()) {
                this.getNodeService().createAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), associationRef.getTypeQName());
            }
        }
        Map<String, Map<String, AssociationRef>> removedAssocs = this.editableNode.getRemovedAssociations();
        for (Map<String, AssociationRef> typedAssoc : removedAssocs.values()) {
            for (AssociationRef associationRef : typedAssoc.values()) {
                this.getNodeService().removeAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), associationRef.getTypeQName());
            }
        }
        Map<String, Map<String, ChildAssociationRef>> addedChildAssocs = this.editableNode.getAddedChildAssociations();
        for (Map map : addedChildAssocs.values()) {
            for (ChildAssociationRef assoc : map.values()) {
                this.getNodeService().addChild(assoc.getParentRef(), assoc.getChildRef(), assoc.getTypeQName(), assoc.getTypeQName());
            }
        }
        Map<String, Map<String, ChildAssociationRef>> removedChildAssocs = this.editableNode.getRemovedChildAssociations();
        for (Map<String, ChildAssociationRef> map : removedChildAssocs.values()) {
            for (ChildAssociationRef assoc : map.values()) {
                this.getNodeService().removeChild(assoc.getParentRef(), assoc.getChildRef());
            }
        }
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        this.browseBean.getDocument().reset();
        return outcome;
    }

    @Override
    protected String formatErrorMessage(Throwable exception) {
        ContentData content;
        if (this.editableNode != null && (content = (ContentData)this.editableNode.getProperties().get(ContentModel.PROP_CONTENT)) != null) {
            this.editableNode.getProperties().put(TEMP_PROP_MIMETYPE, content.getMimetype());
            this.editableNode.getProperties().put(TEMP_PROP_ENCODING, content.getEncoding());
        }
        if (exception instanceof FileExistsException) {
            return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_exists"), ((FileExistsException)exception).getName());
        }
        if (exception instanceof InvalidNodeRefException) {
            return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), this.browseBean.getDocument().getId());
        }
        return super.formatErrorMessage(exception);
    }

    @Override
    protected String getErrorOutcome(Throwable exception) {
        if (exception instanceof InvalidNodeRefException) {
            return "browse";
        }
        return super.getErrorOutcome(exception);
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    public Node getEditableNode() {
        return this.editableNode;
    }
}

