/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.dashboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dashboard.Column;
import org.alfresco.web.bean.dashboard.DashboardManager;
import org.alfresco.web.bean.dashboard.PageConfig;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.config.DashboardsConfigElement;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.description.UIDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardWizard
extends BaseWizardBean {
    private static final long serialVersionUID = 2544040677742418309L;
    private static final String COMPONENT_COLUMNDASHLETS = "column-dashlets";
    private static final String COMPONENT_ALLDASHLETS = "all-dashlets";
    private static final String MSG_COLUMN = "dashboard_column";
    private List<UIListItem> layoutIcons = null;
    private List<UIDescription> layoutDescriptions = null;
    private List<SelectItem> dashlets = null;
    private String layout;
    private int column;
    private PageConfig editConfig;
    private DashboardManager dashboardManager;

    public void setDashboardManager(DashboardManager dashboardManager) {
        this.dashboardManager = dashboardManager;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.editConfig = new PageConfig(this.dashboardManager.getPageConfig());
        this.layout = this.editConfig.getCurrentPage().getLayoutDefinition().Id;
        this.column = 0;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.dashboardManager.savePageConfig(this.editConfig);
        return outcome;
    }

    public String getSummary() {
        DashboardsConfigElement.LayoutDefinition def = DashboardManager.getDashboardConfig().getLayoutDefinition(this.layout);
        String label = def.Label;
        if (label == null) {
            label = Application.getMessage(FacesContext.getCurrentInstance(), def.LabelId);
        }
        return this.buildSummary(new String[]{Application.getMessage(FacesContext.getCurrentInstance(), "step_layout")}, new String[]{label});
    }

    public boolean getAllowGuestConfig() {
        return DashboardManager.getDashboardConfig().getAllowGuestConfig();
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
        DashboardsConfigElement.LayoutDefinition def = DashboardManager.getDashboardConfig().getLayoutDefinition(layout);
        this.editConfig.getCurrentPage().setLayoutDefinition(def);
        if (this.column >= def.Columns) {
            this.column = def.Columns - 1;
        }
    }

    public int getColumnCount() {
        return DashboardManager.getDashboardConfig().getLayoutDefinition((String)this.getLayout()).Columns;
    }

    public int getColumnMax() {
        return DashboardManager.getDashboardConfig().getLayoutDefinition((String)this.getLayout()).ColumnLength;
    }

    public SelectItem[] getColumns() {
        FacesContext fc = FacesContext.getCurrentInstance();
        DashboardsConfigElement.LayoutDefinition layoutDef = DashboardManager.getDashboardConfig().getLayoutDefinition(this.getLayout());
        SelectItem[] columns = new SelectItem[layoutDef.Columns];
        for (int i = 0; i < layoutDef.Columns; ++i) {
            String label = Application.getMessage(fc, MSG_COLUMN) + " " + Integer.toString(i + 1);
            columns[i] = new SelectItem((Object)i, label);
        }
        return columns;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        if (column != this.column) {
            this.column = column;
        }
    }

    public List<SelectItem> getAllDashlets() {
        if (this.dashlets == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext fc = FacesContext.getCurrentInstance();
            DashboardsConfigElement config = DashboardManager.getDashboardConfig();
            Collection<DashboardsConfigElement.DashletDefinition> dashletDefs = config.getDashlets();
            ArrayList<SelectItem> dashlets = new ArrayList<SelectItem>(dashletDefs.size());
            for (DashboardsConfigElement.DashletDefinition dashletDef : dashletDefs) {
                String description;
                String label = dashletDef.Label;
                if (label == null) {
                    label = Application.getMessage(fc, dashletDef.LabelId);
                }
                if ((description = dashletDef.Description) == null) {
                    description = Application.getMessage(fc, dashletDef.DescriptionId);
                }
                if (description != null) {
                    label = label + " (" + description + ')';
                }
                SelectItem item = new SelectItem((Object)dashletDef.Id, label);
                dashlets.add(item);
            }
            this.dashlets = dashlets;
        }
        return this.dashlets;
    }

    public List<SelectItem> getColumnDashlets() {
        FacesContext fc = FacesContext.getCurrentInstance();
        Column column = this.editConfig.getCurrentPage().getColumns().get(this.column);
        DashboardsConfigElement.LayoutDefinition layoutDef = this.editConfig.getCurrentPage().getLayoutDefinition();
        column.trimDashlets(layoutDef.ColumnLength);
        ArrayList<SelectItem> dashlets = new ArrayList<SelectItem>(column.getDashlets().size());
        for (DashboardsConfigElement.DashletDefinition dashletDef : column.getDashlets()) {
            String label = dashletDef.Label;
            if (label == null) {
                label = Application.getMessage(fc, dashletDef.LabelId);
            }
            dashlets.add(new SelectItem((Object)dashletDef.Id, label));
        }
        return dashlets;
    }

    public int getColumnDashletCount() {
        Column column = this.editConfig.getCurrentPage().getColumns().get(this.column);
        return column.getDashlets().size();
    }

    public List<UIDescription> getLayoutDescriptions() {
        if (this.layoutDescriptions == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.buildLayoutValueLists();
        }
        return this.layoutDescriptions;
    }

    public List<UIListItem> getLayoutIcons() {
        if (this.layoutIcons == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.buildLayoutValueLists();
        }
        return this.layoutIcons;
    }

    private void buildLayoutValueLists() {
        ArrayList<UIListItem> icons = new ArrayList<UIListItem>(4);
        ArrayList<UIDescription> descriptions = new ArrayList<UIDescription>(4);
        FacesContext context = FacesContext.getCurrentInstance();
        DashboardsConfigElement config = DashboardManager.getDashboardConfig();
        for (DashboardsConfigElement.LayoutDefinition layoutDef : config.getLayouts()) {
            String desc;
            String label = layoutDef.Label;
            if (label == null) {
                label = Application.getMessage(context, layoutDef.LabelId);
            }
            if ((desc = layoutDef.Description) == null) {
                desc = Application.getMessage(context, layoutDef.DescriptionId);
            }
            UIListItem item = new UIListItem();
            item.setLabel(label);
            item.setTooltip(desc);
            item.setValue(layoutDef.Id);
            item.setImage(layoutDef.Image);
            icons.add(item);
            UIDescription description = new UIDescription();
            description.setControlValue(layoutDef.Id);
            description.setText(desc);
            descriptions.add(description);
        }
        this.layoutIcons = icons;
        this.layoutDescriptions = descriptions;
    }

    public void addDashlets(ActionEvent event) {
        UISelectMany dashletPicker = (UISelectMany)event.getComponent().findComponent(COMPONENT_ALLDASHLETS);
        UISelectOne dashletColumn = (UISelectOne)event.getComponent().findComponent(COMPONENT_COLUMNDASHLETS);
        Object[] selected = dashletPicker.getSelectedValues();
        if (selected.length != 0) {
            DashboardsConfigElement config = DashboardManager.getDashboardConfig();
            DashboardsConfigElement.LayoutDefinition layoutDef = this.editConfig.getCurrentPage().getLayoutDefinition();
            Column column = this.editConfig.getCurrentPage().getColumns().get(this.column);
            for (int i = 0; i < selected.length && column.getDashlets().size() < layoutDef.ColumnLength; ++i) {
                String dashletId = (String)selected[i];
                boolean found = false;
                for (int x = 0; x < column.getDashlets().size(); ++x) {
                    if (!column.getDashlets().get((int)x).Id.equals(dashletId)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                column.addDashlet(config.getDashletDefinition(dashletId));
            }
        }
    }

    public void removeDashlet(ActionEvent event) {
        UISelectOne dashletColumn = (UISelectOne)event.getComponent().findComponent(COMPONENT_COLUMNDASHLETS);
        String dashletId = (String)dashletColumn.getValue();
        if (dashletId != null) {
            Column column = this.editConfig.getCurrentPage().getColumns().get(this.column);
            for (int i = 0; i < column.getDashlets().size(); ++i) {
                if (!column.getDashlets().get((int)i).Id.equals(dashletId)) continue;
                column.getDashlets().remove(i);
                break;
            }
        }
    }

    public void dashletUp(ActionEvent event) {
        UISelectOne dashletColumn = (UISelectOne)event.getComponent().findComponent(COMPONENT_COLUMNDASHLETS);
        String dashletId = (String)dashletColumn.getValue();
        if (dashletId != null) {
            Column column = this.editConfig.getCurrentPage().getColumns().get(this.column);
            for (int i = 0; i < column.getDashlets().size(); ++i) {
                if (!column.getDashlets().get((int)i).Id.equals(dashletId)) continue;
                if (i == 0) break;
                DashboardsConfigElement.DashletDefinition dashletDef = column.getDashlets().get(i);
                column.getDashlets().remove(i);
                column.getDashlets().add(i - 1, dashletDef);
                break;
            }
        }
    }

    public void dashletDown(ActionEvent event) {
        UISelectOne dashletColumn = (UISelectOne)event.getComponent().findComponent(COMPONENT_COLUMNDASHLETS);
        String dashletId = (String)dashletColumn.getValue();
        if (dashletId != null) {
            Column column = this.editConfig.getCurrentPage().getColumns().get(this.column);
            for (int i = 0; i < column.getDashlets().size(); ++i) {
                if (!column.getDashlets().get((int)i).Id.equals(dashletId)) continue;
                if (i == column.getDashlets().size() - 1) break;
                DashboardsConfigElement.DashletDefinition dashletDef = column.getDashlets().get(i);
                column.getDashlets().remove(i);
                if (i + 1 < column.getDashlets().size()) {
                    column.getDashlets().add(i + 1, dashletDef);
                    break;
                }
                column.getDashlets().add(dashletDef);
                break;
            }
        }
    }
}

