/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.forums;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.forums.CreateTopicDialog;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDiscussionDialog
extends CreateTopicDialog {
    private static final long serialVersionUID = 3500493916528264014L;
    protected NodeRef discussingNodeRef;
    private static final Log logger = LogFactory.getLog(CreateDiscussionDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        String id = parameters.get("id");
        if (id == null || id.length() == 0) {
            throw new AlfrescoRuntimeException("createDiscussion called without an id");
        }
        this.createTopic(id);
    }

    @Override
    public String cancel() {
        this.deleteTopic();
        FacesContext.getCurrentInstance().getExternalContext().getSessionMap().remove("externalDialogContainer");
        return this.getDefaultCancelOutcome();
    }

    protected void createTopic(final String id) {
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createTopicCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef forumNodeRef = null;
                CreateDiscussionDialog.this.discussingNodeRef = new NodeRef(Repository.getStoreRef(), id);
                if (CreateDiscussionDialog.this.getNodeService().hasAspect(CreateDiscussionDialog.this.discussingNodeRef, ForumModel.ASPECT_DISCUSSABLE)) {
                    throw new AlfrescoRuntimeException("createDiscussion called for an object that already has a discussion!");
                }
                CreateDiscussionDialog.this.getNodeService().addAspect(CreateDiscussionDialog.this.discussingNodeRef, ForumModel.ASPECT_DISCUSSABLE, null);
                List destChildren = CreateDiscussionDialog.this.getNodeService().getChildAssocs(CreateDiscussionDialog.this.discussingNodeRef, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL);
                if (destChildren.size() == 0) {
                    CreateDiscussionDialog.this.getNodeService().removeAspect(CreateDiscussionDialog.this.discussingNodeRef, ForumModel.ASPECT_DISCUSSABLE);
                    CreateDiscussionDialog.this.getNodeService().addAspect(CreateDiscussionDialog.this.discussingNodeRef, ForumModel.ASPECT_DISCUSSABLE, null);
                    destChildren = CreateDiscussionDialog.this.getNodeService().getChildAssocs(CreateDiscussionDialog.this.discussingNodeRef, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL);
                }
                if (destChildren.size() == 0) {
                    throw new AlfrescoRuntimeException("The discussable aspect behaviour is not creating a topic");
                }
                ChildAssociationRef discussionAssoc = (ChildAssociationRef)destChildren.get(0);
                forumNodeRef = discussionAssoc.getChildRef();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("created forum for content: " + CreateDiscussionDialog.this.discussingNodeRef.toString()));
                }
                return forumNodeRef;
            }
        };
        FacesContext context = FacesContext.getCurrentInstance();
        NodeRef forumNodeRef = null;
        try {
            forumNodeRef = (NodeRef)this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTopicCallback, false);
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
            throw new AbortProcessingException("Invalid node reference");
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
        if (forumNodeRef != null) {
            this.browseBean.clickSpace(forumNodeRef);
        }
    }

    protected void deleteTopic() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteTopicCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                Node forumNode = CreateDiscussionDialog.this.navigator.getCurrentNode();
                CreateDiscussionDialog.this.browseBean.removeSpaceFromBreadcrumb(forumNode);
                CreateDiscussionDialog.this.getNodeService().removeAspect(CreateDiscussionDialog.this.discussingNodeRef, ForumModel.ASPECT_DISCUSSABLE);
                return null;
            }
        };
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteTopicCallback, false);
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
    }
}

