/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.generator;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.NumericRangeConstraint;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.generator.IComponentGenerator;
import org.alfresco.web.bean.repository.DataDictionary;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.repo.component.UIMultiValueEditor;
import org.alfresco.web.ui.repo.component.property.BaseAssociationEditor;
import org.alfresco.web.ui.repo.component.property.PropertySheetItem;
import org.alfresco.web.ui.repo.component.property.UIProperty;
import org.alfresco.web.ui.repo.component.property.UIPropertySheet;
import org.alfresco.web.ui.repo.component.property.UISeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.jsf.FacesContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseComponentGenerator
implements IComponentGenerator {
    private static Log logger = LogFactory.getLog(BaseComponentGenerator.class);
    private DataDictionary dataDictionary;

    @Override
    public UIComponent generateAndAdd(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item) {
        UIComponent component = null;
        if (item instanceof UIProperty) {
            PropertyDefinition propertyDef = this.getPropertyDefinition(context, propertySheet.getNode(), item.getName());
            component = this.createComponent(context, propertySheet, item);
            component = this.setupMultiValuePropertyIfNecessary(context, propertySheet, item, propertyDef, component);
            this.setupProperty(context, propertySheet, item, propertyDef, component);
            item.getChildren().add(component);
            this.setupMandatoryPropertyIfNecessary(context, propertySheet, item, propertyDef, component);
            this.setupConstraints(context, propertySheet, item, propertyDef, component);
            this.setupConverter(context, propertySheet, item, propertyDef, component);
        } else if (item instanceof UISeparator) {
            component = this.createComponent(context, propertySheet, item);
            item.getChildren().add(component);
        } else {
            AssociationDefinition assocationDef = this.getAssociationDefinition(context, propertySheet.getNode(), item.getName());
            component = this.createComponent(context, propertySheet, item);
            this.setupAssociation(context, propertySheet, item, assocationDef, component);
            item.getChildren().add(component);
            this.setupMandatoryAssociationIfNecessary(context, propertySheet, item, assocationDef, component);
            this.setupConverter(context, propertySheet, item, assocationDef, component);
        }
        return component;
    }

    protected UIComponent createComponent(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item) {
        Object component = null;
        component = item instanceof UIProperty ? (propertySheet.inEditMode() ? this.generate(context, item.getName()) : this.createOutputTextComponent(context, item.getName())) : this.generate(context, item.getName());
        return component;
    }

    protected void createAndSetConverter(FacesContext context, String converterId, UIComponent component) {
        if (converterId != null && component instanceof UIOutput) {
            try {
                Converter conv = context.getApplication().createConverter(converterId);
                ((UIOutput)component).setConverter(conv);
            }
            catch (NullPointerException npe) {
                logger.warn((Object)("Converter " + converterId + " could not be applied"));
            }
            catch (FacesException fe) {
                logger.warn((Object)("Converter " + converterId + " could not be applied"));
            }
        }
    }

    protected UIOutput createOutputTextComponent(FacesContext context, String id) {
        UIOutput component = (UIOutput)context.getApplication().createComponent("javax.faces.Output");
        component.setRendererType("javax.faces.Text");
        FacesHelper.setupComponentId(context, (UIComponent)component, id);
        return component;
    }

    protected void setupProperty(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item, PropertyDefinition propertyDef, UIComponent component) {
        ValueBinding vb = null;
        vb = propertyDef != null ? context.getApplication().createValueBinding("#{" + propertySheet.getVar() + ".properties[\"" + propertyDef.getName().toString() + "\"]}") : context.getApplication().createValueBinding("#{" + propertySheet.getVar() + ".properties[\"" + item.getName() + "\"]}");
        component.setValueBinding("value", vb);
        if (!propertySheet.inEditMode() || item.isReadOnly() || propertyDef != null && propertyDef.isProtected()) {
            component.getAttributes().put("disabled", Boolean.TRUE);
        }
    }

    protected void setupAssociation(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item, AssociationDefinition associationDef, UIComponent component) {
        ValueBinding vb = context.getApplication().createValueBinding("#{" + propertySheet.getVar() + "}");
        component.setValueBinding("value", vb);
        ((BaseAssociationEditor)component).setAssociationName(associationDef.getName().toString());
        if (!propertySheet.inEditMode() || item.isReadOnly() || associationDef != null && associationDef.isProtected()) {
            component.getAttributes().put("disabled", Boolean.TRUE);
        }
    }

    protected UIComponent setupMultiValuePropertyIfNecessary(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, PropertyDefinition propertyDef, UIComponent component) {
        UIComponent multiValueComponent = component;
        if (propertySheet.inEditMode() && !property.isReadOnly() && propertyDef != null && !propertyDef.isProtected() && propertyDef.isMultiValued()) {
            String id = "multi_" + property.getName();
            multiValueComponent = context.getApplication().createComponent("org.alfresco.faces.MultiValueEditor");
            FacesHelper.setupComponentId(context, multiValueComponent, id);
            if (this.getControlType() == ControlType.FIELD) {
                multiValueComponent.setRendererType("org.alfresco.faces.Field");
                if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                    multiValueComponent.getAttributes().put("mltext", Boolean.TRUE);
                }
            } else {
                multiValueComponent.setRendererType("org.alfresco.faces.Selector");
                String expr = "#{MultiValueEditorBean.lastItemsAdded['" + property.getName() + "']}";
                ValueBinding vb = context.getApplication().createValueBinding(expr);
                multiValueComponent.setValueBinding("lastItemAdded", vb);
                component.setValueBinding("value", vb);
            }
            multiValueComponent.getChildren().add(component);
        }
        return multiValueComponent;
    }

    protected void setupMandatoryPropertyIfNecessary(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, PropertyDefinition propertyDef, UIComponent component) {
        if (propertySheet.inEditMode() && propertySheet.isValidationEnabled() && propertyDef != null && propertyDef.isMandatory()) {
            this.setupMandatoryValidation(context, propertySheet, property, component, false, null);
            this.setupMandatoryMarker(context, property);
        }
    }

    protected void setupMandatoryAssociationIfNecessary(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem association, AssociationDefinition associationDef, UIComponent component) {
        if (propertySheet.inEditMode() && propertySheet.isValidationEnabled() && associationDef != null && associationDef.isTargetMandatory()) {
            this.setupMandatoryValidation(context, propertySheet, association, component, false, null);
            this.setupMandatoryMarker(context, association);
        }
    }

    protected void setupMandatoryValidation(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item, UIComponent component, boolean realTimeChecking, String idSuffix) {
        ArrayList<String> params = new ArrayList<String>(3);
        StringBuilder value = new StringBuilder("document.getElementById('");
        value.append(component.getClientId(context));
        if (idSuffix != null) {
            value.append(idSuffix);
        }
        value.append("')");
        params.add(value.toString());
        String msg = Application.getMessage(context, "validation_mandatory");
        this.addStringConstraintParam(params, MessageFormat.format(msg, item.getResolvedDisplayLabel()));
        propertySheet.addClientValidation(new UIPropertySheet.ClientValidation("validateMandatory", params, realTimeChecking));
    }

    protected void setupMandatoryMarker(FacesContext context, PropertySheetItem item) {
        UIGraphic image = (UIGraphic)context.getApplication().createComponent("javax.faces.Graphic");
        image.setUrl("/images/icons/required_field.gif");
        image.getAttributes().put("style", "padding-right: 4px;");
        item.getChildren().add(image);
    }

    protected void setupConstraints(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, PropertyDefinition propertyDef, UIComponent component) {
        if (propertySheet.inEditMode() && propertySheet.isValidationEnabled() && propertyDef != null) {
            List constraints = propertyDef.getConstraints();
            for (ConstraintDefinition constraintDef : constraints) {
                Constraint constraint = constraintDef.getConstraint();
                if (constraint instanceof RegexConstraint) {
                    this.setupRegexConstraint(context, propertySheet, property, component, (RegexConstraint)constraint, false);
                    continue;
                }
                if (constraint instanceof StringLengthConstraint) {
                    this.setupStringLengthConstraint(context, propertySheet, property, component, (StringLengthConstraint)constraint, false);
                    continue;
                }
                if (constraint instanceof NumericRangeConstraint) {
                    this.setupNumericRangeConstraint(context, propertySheet, property, component, (NumericRangeConstraint)constraint, false);
                    continue;
                }
                if (!(constraint instanceof ListOfValuesConstraint)) continue;
            }
        }
    }

    protected void setupRegexConstraint(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, UIComponent component, RegexConstraint constraint, boolean realTimeChecking) {
        String expression = constraint.getExpression();
        boolean requiresMatch = constraint.getRequiresMatch();
        ArrayList<String> params = new ArrayList<String>(3);
        String value = "document.getElementById('" + component.getClientId(context) + (component instanceof UIMultiValueEditor ? "_current_value" : "") + "')";
        params.add(value);
        try {
            this.addStringConstraintParam(params, URLEncoder.encode(expression, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.addStringConstraintParam(params, expression);
        }
        params.add(Boolean.toString(requiresMatch));
        String matchMsg = Application.getMessage(context, "validation_regex");
        this.addStringConstraintParam(params, MessageFormat.format(matchMsg, property.getResolvedDisplayLabel()));
        String noMatchMsg = Application.getMessage(context, "validation_regex_not_match");
        this.addStringConstraintParam(params, MessageFormat.format(noMatchMsg, property.getResolvedDisplayLabel()));
        propertySheet.addClientValidation(new UIPropertySheet.ClientValidation(component instanceof UIMultiValueEditor ? "validateMultivalueRegex" : "validateRegex", params, realTimeChecking));
    }

    protected void setupStringLengthConstraint(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, UIComponent component, StringLengthConstraint constraint, boolean realTimeChecking) {
        int min = constraint.getMinLength();
        int max = constraint.getMaxLength();
        ArrayList<String> params = new ArrayList<String>(3);
        String value = "document.getElementById('" + component.getClientId(context) + "')";
        params.add(value);
        params.add(Integer.toString(min));
        params.add(Integer.toString(max));
        String msg = Application.getMessage(context, "validation_string_length");
        this.addStringConstraintParam(params, MessageFormat.format(msg, property.getResolvedDisplayLabel(), min, max));
        propertySheet.addClientValidation(new UIPropertySheet.ClientValidation("validateStringLength", params, realTimeChecking));
    }

    protected void setupNumericRangeConstraint(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, UIComponent component, NumericRangeConstraint constraint, boolean realTimeChecking) {
        double min = constraint.getMinValue();
        double max = constraint.getMaxValue();
        ArrayList<String> params = new ArrayList<String>(3);
        String value = "document.getElementById('" + component.getClientId(context) + "')";
        params.add(value);
        params.add(Double.toString(min));
        params.add(Double.toString(max));
        String msg = Application.getMessage(context, "validation_numeric_range");
        this.addStringConstraintParam(params, MessageFormat.format(msg, property.getResolvedDisplayLabel(), min, max));
        propertySheet.addClientValidation(new UIPropertySheet.ClientValidation("validateNumberRange", params, false));
    }

    protected void setupConverter(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, PropertyDefinition propertyDef, UIComponent component) {
        if (property.getConverter() != null) {
            this.createAndSetConverter(context, property.getConverter(), component);
        } else if (!propertySheet.inEditMode() && propertyDef != null && propertyDef.isMultiValued()) {
            this.createAndSetConverter(context, "org.alfresco.faces.MultiValueConverter", component);
        }
    }

    protected void setupConverter(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem association, AssociationDefinition associationDef, UIComponent component) {
        if (association.getConverter() != null) {
            this.createAndSetConverter(context, association.getConverter(), component);
        }
    }

    protected ControlType getControlType() {
        return ControlType.FIELD;
    }

    protected PropertyDefinition getPropertyDefinition(FacesContext context, Node node, String propertyName) {
        return this.getDataDictionary(context).getPropertyDefinition(node, propertyName);
    }

    protected AssociationDefinition getAssociationDefinition(FacesContext context, Node node, String associationName) {
        return this.getDataDictionary(context).getAssociationDefinition(node, associationName);
    }

    protected void addStringConstraintParam(List<String> params, String param) {
        params.add("\"" + StringUtils.replace((String)param, (String)"\"", (String)"\\\"") + "\"");
    }

    private DataDictionary getDataDictionary(FacesContext context) {
        if (this.dataDictionary == null) {
            this.dataDictionary = (DataDictionary)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("dataDictionary");
        }
        return this.dataDictionary;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ControlType {
        FIELD,
        SELECTOR;

    }
}

