/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.generator;

import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.generator.BaseComponentGenerator;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.alfresco.web.ui.repo.component.property.PropertySheetItem;
import org.alfresco.web.ui.repo.component.property.UIPropertySheet;

public class LanguageSelectorGenerator
extends BaseComponentGenerator {
    protected Node node;
    protected UserPreferencesBean userPreferencesBean;

    public UIComponent generate(FacesContext context, String id) {
        UIComponent component = context.getApplication().createComponent("javax.faces.SelectOne");
        FacesHelper.setupComponentId(context, component, id);
        UISelectItems itemsComponent = (UISelectItems)context.getApplication().createComponent("javax.faces.SelectItems");
        itemsComponent.setValue((Object)this.getLanguageItems());
        component.getChildren().add(itemsComponent);
        return component;
    }

    protected SelectItem[] getLanguageItems() {
        SelectItem[] items = this.userPreferencesBean.getAvailablesContentFilterLanguages(this.node.getNodeRef(), true);
        return items;
    }

    protected UIComponent createComponent(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item) {
        this.node = propertySheet.getNode();
        return super.createComponent(context, propertySheet, item);
    }

    protected void setupConverter(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, PropertyDefinition propertyDef, UIComponent component) {
        this.createAndSetConverter(context, "org.alfresco.faces.LanguageConverter", component);
    }

    protected void setupMandatoryValidation(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item, UIComponent component, boolean realTimeChecking, String idSuffix) {
    }

    public void setUserPreferencesBean(UserPreferencesBean userPreferencesBean) {
        this.userPreferencesBean = userPreferencesBean;
    }
}

