/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ml;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.ml.AddTranslationDialog;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeMultilingualDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -2862474360129631088L;
    private transient MultilingualContentService multilingualContentService;
    private UserPreferencesBean userPreferencesBean;
    public static final String OPT_ADD_WITH_CONTENT = "ADD_WITH_CONTENT";
    public static final String OPT_ADD_WITHOUT_CONTENT = "ADD_WITHOUT_CONTENT";
    private String author;
    private String language;
    private boolean addTranslationAfter = true;
    private String addingMode = "ADD_WITH_CONTENT";
    protected Node editableNode;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.editableNode = this.initEditableNode();
        NodeRef nodeRef = this.editableNode.getNodeRef();
        if (this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_AUTHOR) && this.getNodeService().getProperty(nodeRef, ContentModel.PROP_AUTHOR) != null) {
            this.setAuthor((String)((Object)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_AUTHOR)));
        } else {
            this.setAuthor("");
        }
        if (this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_LOCALIZED) && this.getNodeService().getProperty(nodeRef, ContentModel.PROP_LOCALE) != null) {
            this.setLanguage(((Locale)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_LOCALE)).toString());
        } else {
            this.setLanguage(null);
        }
        this.addTranslationAfter = false;
        this.addingMode = OPT_ADD_WITH_CONTENT;
    }

    protected Node initEditableNode() {
        return new Node(this.browseBean.getDocument().getNodeRef());
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        Locale locale = I18NUtil.parseLocale((String)this.getLanguage());
        NodeRef nodeRef = this.editableNode.getNodeRef();
        this.getMultilingualContentService().makeTranslation(nodeRef, locale);
        NodeRef mlContainer = this.getMultilingualContentService().getTranslationContainer(nodeRef);
        String nodeAuthor = (String)((Object)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_AUTHOR));
        if (nodeAuthor == null || nodeAuthor.length() < 1) {
            this.getNodeService().setProperty(nodeRef, ContentModel.PROP_AUTHOR, (Serializable)((Object)this.getAuthor()));
        }
        this.getNodeService().setProperty(mlContainer, ContentModel.PROP_AUTHOR, (Serializable)((Object)this.getAuthor()));
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        this.browseBean.getDocument().reset();
        if (this.addTranslationAfter) {
            if (this.addingMode.equalsIgnoreCase(OPT_ADD_WITHOUT_CONTENT)) {
                return "dialog:addTranslationWithoutContent";
            }
            AddTranslationDialog dialog = (AddTranslationDialog)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "AddTranslationDialog");
            dialog.start(null);
            return "dialog:addTranslation";
        }
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.author == null || this.author.length() == 0 || this.language == null || this.language.length() == 0;
    }

    public Node getEditableNode() {
        return this.editableNode;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean isAddTranslationAfter() {
        return this.addTranslationAfter;
    }

    public void setAddTranslationAfter(boolean addTranslationAfter) {
        this.addTranslationAfter = addTranslationAfter;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setEditableNode(Node editableNode) {
        this.editableNode = editableNode;
    }

    public String getAddingMode() {
        return this.addingMode;
    }

    public void setAddingMode(String addingMode) {
        this.addingMode = addingMode;
    }

    public SelectItem[] getFilterLanguages() {
        return this.userPreferencesBean.getContentFilterLanguages(false);
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    private MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }

    public void setUserPreferencesBean(UserPreferencesBean userPreferencesBean) {
        this.userPreferencesBean = userPreferencesBean;
    }
}

