/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.ml.ContentFilterLanguagesService;
import org.alfresco.service.cmr.ml.EditionService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewEditionWizard
extends BaseWizardBean {
    private static final long serialVersionUID = 2078582486053536124L;
    public static final String ID_MESSAGE_MINOR_CHANGE = "minor_change";
    public static final String ID_MESSAGE_MAJOR_CHANGE = "major_change";
    private transient EditionService editionService;
    private transient MultilingualContentService multilingualContentService;
    private transient ContentFilterLanguagesService contentFilterLanguagesService;
    private transient LockService lockService;
    private transient VersionService versionService;
    protected NodeRef mlContainerToVersion;
    private List<TranslationWrapper> selectableTranslations;
    private List<TranslationWrapper> translationsCheckedOut;
    private String editionNotes;
    private boolean minorChange;
    private boolean otherProperties;
    private boolean skipFirstStep;
    private String language;
    private String title;
    private boolean hasTranslationCheckedOut;
    private NodeRef startingElement;
    private String author;
    private String selectedLanguage;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.editionNotes = null;
        this.minorChange = true;
        this.otherProperties = false;
        this.translationsCheckedOut = null;
        this.selectableTranslations = null;
        if (!this.skipFirstStep) {
            this.language = null;
            this.title = null;
            this.setMLContainer();
        }
        this.initTranslationList();
        this.hasTranslationCheckedOut = this.translationsCheckedOut.size() > 0;
    }

    public void skipFirstStep(ActionEvent event) {
        this.skipFirstStep = true;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String lang = params.get("lang");
        ParameterCheck.mandatoryString((String)"The lang of the node", (String)lang);
        this.setMLContainer();
        this.setStartingItem(lang.toLowerCase());
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        HashMap<String, String> versionProperties = new HashMap<String, String>(1, 1.0f);
        versionProperties.put("description", this.editionNotes);
        if (this.minorChange) {
            versionProperties.put("versionType", (String)VersionType.MINOR);
        } else {
            versionProperties.put("versionType", (String)VersionType.MAJOR);
        }
        NodeRef newPivot = this.getEditionService().createEdition(this.startingElement, versionProperties);
        if (this.otherProperties) {
            this.browseBean.setDocument(new Node(newPivot));
            outcome = "dialog:close:dialog:setContentProperties";
        } else {
            outcome = "dialog:close:browse";
        }
        this.skipFirstStep = false;
        return outcome;
    }

    public DataModel getTranslationsCheckedOutDataModel() {
        return this.getDataModel(this.translationsCheckedOut);
    }

    public DataModel getAvailableTranslationsDataModel() {
        return this.getDataModel(this.selectableTranslations);
    }

    public boolean getHasTranslationCheckedOut() {
        return this.hasTranslationCheckedOut;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return super.getFinishButtonDisabled() || this.hasTranslationCheckedOut;
    }

    @Override
    public boolean getNextButtonDisabled() {
        return super.getNextButtonDisabled() || this.hasTranslationCheckedOut;
    }

    private void setStartingItem(String language) {
        this.startingElement = this.getMultilingualContentService().getTranslationForLocale(this.mlContainerToVersion, I18NUtil.parseLocale((String)language));
        this.setLanguage(language);
        this.setTitle((String)((Object)this.getNodeService().getProperty(this.startingElement, ContentModel.PROP_TITLE)));
        this.setAuthor((String)((Object)this.getNodeService().getProperty(this.startingElement, ContentModel.PROP_AUTHOR)));
    }

    private DataModel getDataModel(Object rows) {
        ListDataModel translationDataModel = new ListDataModel();
        translationDataModel.setWrappedData(rows);
        return translationDataModel;
    }

    private void initTranslationList() {
        this.translationsCheckedOut = new ArrayList<TranslationWrapper>();
        this.selectableTranslations = new ArrayList<TranslationWrapper>();
        Map translations = this.getMultilingualContentService().getTranslations(this.mlContainerToVersion);
        for (Map.Entry entry : translations.entrySet()) {
            LockStatus lockStatus;
            NodeRef nodeRef = (NodeRef)entry.getValue();
            String name = (String)((Object)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_NAME));
            String langCode = ((Locale)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_LOCALE)).getLanguage();
            String langText = this.getContentFilterLanguagesService().getLabelByCode(langCode);
            String lockOwner = (String)((Object)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_LOCK_OWNER));
            TranslationWrapper wrapper = new TranslationWrapper(name, langCode, lockOwner, langText);
            if (!this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                this.selectableTranslations.add(wrapper);
            }
            if (!this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) || (lockStatus = this.getLockService().getLockStatus(nodeRef)) == LockStatus.NO_LOCK) continue;
            this.translationsCheckedOut.add(wrapper);
        }
    }

    private void setMLContainer() {
        NodeRef currentNodeRef = this.browseBean.getDocument().getNodeRef();
        this.mlContainerToVersion = ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)this.getNodeService().getType(currentNodeRef)) ? currentNodeRef : this.getMultilingualContentService().getTranslationContainer(currentNodeRef);
        if (!this.skipFirstStep) {
            this.selectedLanguage = ((Locale)this.getNodeService().getProperty(this.mlContainerToVersion, ContentModel.PROP_LOCALE)).getLanguage();
        }
    }

    public String getEditionNotes() {
        return this.editionNotes;
    }

    public void setEditionNotes(String editionNotes) {
        this.editionNotes = editionNotes;
    }

    public boolean isMinorChange() {
        return this.minorChange;
    }

    public void setMinorChange(boolean minorChange) {
        this.minorChange = minorChange;
    }

    public boolean isOtherProperties() {
        return this.otherProperties;
    }

    public void setOtherProperties(boolean otherProperties) {
        this.otherProperties = otherProperties;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getLanguage() {
        return this.getContentFilterLanguagesService().getLabelByCode(this.language);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setLanguage(Locale locale) {
        this.language = locale.getLanguage();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getVersionLabel() {
        String label = this.getVersionService().getCurrentVersion(this.mlContainerToVersion).getVersionLabel();
        String nextLabel = null;
        try {
            int dotPosition = label.indexOf(46);
            int major = Integer.parseInt(label.substring(0, dotPosition));
            int minor = Integer.parseInt(label.substring(dotPosition + 1));
            nextLabel = this.minorChange ? major + "." + (minor + 1) : major + 1 + ".0";
        }
        catch (Exception e) {
            nextLabel = "";
        }
        if (this.minorChange) {
            String minorString = Application.getMessage(FacesContext.getCurrentInstance(), ID_MESSAGE_MINOR_CHANGE);
            return nextLabel + " (" + minorString + ')';
        }
        return nextLabel;
    }

    public String getSelectedTranslationLanguage() {
        return this.selectedLanguage;
    }

    public void setSelectedTranslationLanguage(String language) {
        if (language != null) {
            this.setStartingItem(language);
        }
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    protected MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }

    public void setContentFilterLanguagesService(ContentFilterLanguagesService contentFilterLanguagesService) {
        this.contentFilterLanguagesService = contentFilterLanguagesService;
    }

    protected ContentFilterLanguagesService getContentFilterLanguagesService() {
        if (this.contentFilterLanguagesService == null) {
            this.contentFilterLanguagesService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentFilterLanguagesService();
        }
        return this.contentFilterLanguagesService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    protected LockService getLockService() {
        if (this.lockService == null) {
            this.lockService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getLockService();
        }
        return this.lockService;
    }

    public void setEditionService(EditionService editionService) {
        this.editionService = editionService;
    }

    protected EditionService getEditionService() {
        if (this.editionService == null) {
            this.editionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getEditionService();
        }
        return this.editionService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    protected VersionService getVersionService() {
        if (this.versionService == null) {
            this.versionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getVersionService();
        }
        return this.versionService;
    }

    public static class TranslationWrapper
    implements Serializable {
        private static final long serialVersionUID = 5517785385414245587L;
        private String language;
        private String name;
        private String checkedOutBy;
        private String languageLabel;

        public TranslationWrapper(String name, String language, String checkedOutBy, String languageLabel) {
            this.name = name;
            this.language = language;
            this.checkedOutBy = checkedOutBy;
            this.languageLabel = languageLabel;
        }

        public String getCheckedOutBy() {
            return this.checkedOutBy;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getName() {
            return this.name;
        }

        public String getLanguageLabel() {
            return this.languageLabel;
        }
    }
}

