/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository.admin;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import javax.faces.context.FacesContext;
import org.alfresco.repo.admin.RepoAdminInterpreter;
import org.alfresco.web.app.servlet.FacesHelper;

public class RepoAdminConsoleBean
implements Serializable {
    private static final long serialVersionUID = -8131607149189675180L;
    private String command = "";
    private String submittedCommand = "none";
    private long duration = 0L;
    private String result = null;
    private transient RepoAdminInterpreter repoAdminInterpreter;

    public void setRepoAdminInterpreter(RepoAdminInterpreter repoAdminInterpreter) {
        this.repoAdminInterpreter = repoAdminInterpreter;
    }

    private RepoAdminInterpreter getRepoAdminInterpreter() {
        if (this.repoAdminInterpreter == null) {
            this.repoAdminInterpreter = (RepoAdminInterpreter)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "repoAdminInterpreter");
        }
        return this.repoAdminInterpreter;
    }

    public String getResult() {
        if (this.result == null) {
            this.interpretCommand("help");
        }
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getSubmittedCommand() {
        return this.submittedCommand;
    }

    public void setSubmittedCommand(String submittedCommand) {
        this.submittedCommand = submittedCommand;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String submitCommand() {
        this.interpretCommand(this.command);
        return "success";
    }

    public String getCurrentUserName() {
        return this.getRepoAdminInterpreter().getCurrentUserName();
    }

    private void interpretCommand(String command) {
        try {
            long startms = System.currentTimeMillis();
            String result = this.getRepoAdminInterpreter().interpretCommand(command);
            this.setDuration(System.currentTimeMillis() - startms);
            this.setResult(result);
            this.setCommand("");
            this.setSubmittedCommand(command);
        }
        catch (Exception e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            this.setResult(stackTrace.toString());
        }
    }
}

