/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.rules.handlers.BaseConditionHandler;
import org.alfresco.web.bean.wizard.IWizardBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeConditionHandler
extends BaseConditionHandler {
    public static final String NAME = "composite-condition";
    public static final String PROP_COMPOSITE_CONDITION = "composite-condition";
    private static final Log logger = LogFactory.getLog(CompositeConditionHandler.class);
    public static final String PROP_CONDITION_OR = "orconditions";

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> props) {
        List conditionPropertiesList = (List)((Object)props.get("composite-condition"));
        if (conditionPropertiesList == null) {
            logger.error((Object)"Error - composite condition has no sub-conditions");
            if (logger.isDebugEnabled()) {
                for (String str : props.keySet()) {
                    logger.debug((Object)("\t key - " + str + " value " + props.get(str)));
                }
            }
            return Application.getMessage(context, "condition_composite_error");
        }
        Boolean not = (Boolean)props.get("notcondition");
        Boolean orconditions = (Boolean)props.get(PROP_CONDITION_OR);
        String msgId = not != false ? "condition_composite_summary_not" : "condition_composite_summary";
        return MessageFormat.format(Application.getMessage(context, msgId), conditionPropertiesList.size(), orconditions != false ? "ORed" : "ANDed");
    }

    @Override
    public String getJSPPath() {
        return this.getJSPPath("composite-condition");
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> uiConditionProps, Map<String, Serializable> repoProps) {
        Boolean orconditions;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Preparing Composite Condition for Edit");
        }
        if ((orconditions = (Boolean)repoProps.get(PROP_CONDITION_OR)) == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"orconditions is NULL, it should not be.  Defaulting to false");
            }
            orconditions = Boolean.FALSE;
        }
        uiConditionProps.put(PROP_CONDITION_OR, orconditions);
    }

    @Override
    public void prepareForSave(Map<String, Serializable> uiConditionProps, Map<String, Serializable> repoProps) {
        Boolean orconditions;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Saving Composite Condition");
        }
        if ((orconditions = (Boolean)uiConditionProps.get(PROP_CONDITION_OR)) == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"orconditions is NULL, it should not be.  Defaulting to false");
            }
            orconditions = Boolean.FALSE;
        }
        repoProps.put(PROP_CONDITION_OR, orconditions);
    }
}

