/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.search;

import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.search.AdvancedSearchDialog;
import org.alfresco.web.bean.search.SearchContext;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

public class EditSearchDialog
extends AdvancedSearchDialog {
    private static final long serialVersionUID = -8914819218709478527L;
    private static final String MSG_ERROR_SAVE_SEARCH = "error_save_search";

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return this.saveEditSearchOK(context, outcome);
    }

    public String getFinishButtonLabel() {
        return super.getFinishButtonLabel();
    }

    public String saveEditSearchOK(FacesContext newContext, String newOutcome) {
        String outcome = newOutcome;
        final SearchContext search = this.navigator.getSearchContext();
        if (search != null) {
            try {
                final FacesContext context = newContext;
                RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        NodeRef searchRef = new NodeRef(Repository.getStoreRef(), EditSearchDialog.this.properties.getSavedSearch());
                        if (EditSearchDialog.this.getNodeService().exists(searchRef)) {
                            Map props = EditSearchDialog.this.getNodeService().getProperties(searchRef);
                            props.put(ContentModel.PROP_NAME, EditSearchDialog.this.properties.getSearchName());
                            props.put(ContentModel.PROP_DESCRIPTION, EditSearchDialog.this.properties.getSearchDescription());
                            EditSearchDialog.this.getNodeService().setProperties(searchRef, props);
                            ContentService contentService = Repository.getServiceRegistry(context).getContentService();
                            ContentWriter writer = contentService.getWriter(searchRef, ContentModel.PROP_CONTENT, true);
                            writer.setMimetype("text/xml");
                            writer.setEncoding("UTF-8");
                            writer.putContent(search.toXML());
                        }
                        return null;
                    }
                };
                callback.execute();
                this.properties.getCachedSavedSearches().clear();
                this.properties.setSavedSearch(null);
            }
            catch (Throwable e) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(newContext, MSG_ERROR_SAVE_SEARCH), e.getMessage()), e);
                outcome = null;
                this.isFinished = false;
                ReportedException.throwIfNecessary(e);
            }
        }
        return outcome;
    }
}

