/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.trashcan;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.NodePropertyResolver;
import org.alfresco.web.bean.repository.QNameNodeMap;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.trashcan.TrashcanDialogProperty;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIModeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrashcanDialog
extends BaseDialogBean
implements IContextListener {
    private static final long serialVersionUID = -7783683979079046969L;
    protected TrashcanDialogProperty property;
    private static final String MSG_DELETED_ITEMS_FOR = "deleted_items_for";
    private static final String MSG_DELETED_ITEMS = "deleted_items";
    private static final String MSG_RECOVERED_ITEM_INTEGRITY_S = "recovered_item_integrity_short";
    private static final String MSG_RECOVERED_ITEM_PERMISSION_S = "recovered_item_permission_short";
    private static final String MSG_RECOVERED_ITEM_PARENT_S = "recovered_item_parent_short";
    private static final String MSG_RECOVERED_ITEM_FAILURE_S = "recovered_item_failure_short";
    private static final String MSG_RECOVERY_REASON = "recovery_report_reason";
    private static final String MSG_LOCATION = "location";
    private static final String MSG_NAME = "name";
    private static final String MSG_CLOSE = "close";
    private static final String PROP_RECOVERSTATUS = "recoverstatus";
    private static final String FILTER_DATE_ALL = "all";
    private static final String FILTER_DATE_TODAY = "today";
    private static final String FILTER_DATE_WEEK = "week";
    private static final String FILTER_DATE_MONTH = "month";
    private static final String FILTER_USER_USER = "user";
    private static final String OUTCOME_DIALOGCLOSE = "dialog:close";
    private static final String NAME_ATTR = Repository.escapeQName(ContentModel.PROP_NAME);
    private static final String USER_ATTR = Repository.escapeQName(ContentModel.PROP_ARCHIVED_BY);
    private static final String DATE_ATTR = Repository.escapeQName(ContentModel.PROP_ARCHIVED_DATE);
    private static final String SEARCH_ALL = "PARENT:\"%s\" AND ASPECT:\"%s\"";
    private static final String SEARCH_NAME = "PARENT:\"%s\" AND ASPECT:\"%s\" AND (@" + NAME_ATTR + ":*%s* @" + NAME_ATTR + ":\"*%s*\")";
    private static final String SEARCH_TEXT = "PARENT:\"%s\" AND ASPECT:\"%s\" AND TEXT:%s";
    private static final String SEARCH_NAME_QUOTED = "PARENT:\"%s\" AND ASPECT:\"%s\" AND @" + NAME_ATTR + ":\"%s\"";
    private static final String SEARCH_TEXT_QUOTED = "PARENT:\"%s\" AND ASPECT:\"%s\" AND TEXT:\"%s\"";
    private static final String SEARCH_USERPREFIX = "@" + USER_ATTR + ":%s AND ";
    protected transient PermissionService permissionService;
    private NodePropertyResolver resolverLocationPath = new NodePropertyResolver(){
        private static final long serialVersionUID = -2501720368642759082L;

        public Object get(Node node) {
            ChildAssociationRef childRef = (ChildAssociationRef)node.getProperties().get(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
            if (TrashcanDialog.this.getPermissionService().hasPermission(childRef.getParentRef(), "Read").equals((Object)AccessStatus.ALLOWED) && TrashcanDialog.this.getNodeService().exists(childRef.getParentRef())) {
                return TrashcanDialog.this.getNodeService().getPath(childRef.getParentRef());
            }
            return null;
        }
    };
    private NodePropertyResolver resolverDisplayPath = new NodePropertyResolver(){
        private static final long serialVersionUID = 9178556770343499694L;

        public Object get(Node node) {
            ChildAssociationRef childRef = (ChildAssociationRef)node.getProperties().get(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
            if (TrashcanDialog.this.getPermissionService().hasPermission(childRef.getParentRef(), "Read").equals((Object)AccessStatus.ALLOWED) && TrashcanDialog.this.getNodeService().exists(childRef.getParentRef())) {
                return Repository.getDisplayPath(TrashcanDialog.this.getNodeService().getPath(childRef.getParentRef()), true);
            }
            return "";
        }
    };
    private NodePropertyResolver resolverFileType16 = new NodePropertyResolver(){
        private static final long serialVersionUID = 7462526266770371703L;

        public Object get(Node node) {
            return FileTypeImageUtils.getFileTypeImage((String)node.getName(), (boolean)true);
        }
    };
    private NodePropertyResolver resolverSmallIcon = new NodePropertyResolver(){
        private static final long serialVersionUID = 5528945140207247127L;

        public Object get(Node node) {
            QNameNodeMap props = (QNameNodeMap)node.getProperties();
            String icon = (String)props.getRaw("app:icon");
            return "/images/icons/" + (icon != null ? icon + "-16.gif" : "space_small.gif");
        }
    };
    private NodePropertyResolver resolverFileType32 = new NodePropertyResolver(){
        private static final long serialVersionUID = -5681639025578263060L;

        public Object get(Node node) {
            return FileTypeImageUtils.getFileTypeImage((String)node.getName(), (boolean)false);
        }
    };
    private NodePropertyResolver resolverLargeIcon = new NodePropertyResolver(){
        private static final long serialVersionUID = -8334570770580388654L;

        public Object get(Node node) {
            QNameNodeMap props = (QNameNodeMap)node.getProperties();
            String icon = (String)props.getRaw("app:icon");
            return "/images/icons/" + (icon != null ? icon : "space-icon-default") + ".gif";
        }
    };
    private NodePropertyResolver resolverMimetype = new NodePropertyResolver(){
        private static final long serialVersionUID = -5892550146037635522L;

        public Object get(Node node) {
            ContentData content = (ContentData)node.getProperties().get(ContentModel.PROP_CONTENT);
            return content != null ? content.getMimetype() : null;
        }
    };
    private NodePropertyResolver resolverSize = new NodePropertyResolver(){
        private static final long serialVersionUID = -191591211947393578L;

        public Object get(Node node) {
            ContentData content = (ContentData)node.getProperties().get(ContentModel.PROP_CONTENT);
            return content != null ? new Long(content.getSize()) : 0L;
        }
    };
    private NodePropertyResolver resolverEncoding = new NodePropertyResolver(){
        private static final long serialVersionUID = -1594354572323978873L;

        public Object get(Node node) {
            ContentData content = (ContentData)node.getProperties().get(ContentModel.PROP_CONTENT);
            return content != null ? content.getEncoding() : null;
        }
    };
    private NodePropertyResolver resolverDeletedDate = new NodePropertyResolver(){
        private static final long serialVersionUID = 3240286507786251191L;

        public Object get(Node node) {
            return node.getProperties().get(ContentModel.PROP_ARCHIVED_DATE);
        }
    };
    private NodePropertyResolver resolverDeletedBy = new NodePropertyResolver(){
        private static final long serialVersionUID = -8678755146743606599L;

        public Object get(Node node) {
            return node.getProperties().get(ContentModel.PROP_ARCHIVED_BY);
        }
    };
    private NodePropertyResolver resolverIsFolder = new NodePropertyResolver(){
        private static final long serialVersionUID = -9181535522349485509L;

        public Object get(Node node) {
            return TrashcanDialog.this.getDictionaryService().isSubClass(node.getType(), ContentModel.TYPE_FOLDER);
        }
    };

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public void setProperty(TrashcanDialogProperty property) {
        this.property = property;
    }

    public TrashcanDialogProperty getProperty() {
        return this.property;
    }

    public String getPanelMessage() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String msg = Application.getMessage(fc, MSG_DELETED_ITEMS);
        if (!this.isAdminUser()) {
            msg = msg + ' ' + MessageFormat.format(Application.getMessage(fc, MSG_DELETED_ITEMS_FOR), Application.getCurrentUser(fc).getUserName());
        }
        return msg;
    }

    public String getItemBrowserUrl() {
        return Utils.generateURL(FacesContext.getCurrentInstance(), this.property.getItem(), Utils.URLMode.HTTP_INLINE);
    }

    public String getItemDownloadUrl() {
        return Utils.generateURL(FacesContext.getCurrentInstance(), this.property.getItem(), Utils.URLMode.HTTP_DOWNLOAD);
    }

    public String getItemNodeRefUrl() {
        return this.property.getItem().getNodeRef().toString();
    }

    public String getListedItemsTable() {
        return this.buildItemsTable(this.property.getListedItems(), "recoveredItemsList", false, true);
    }

    public String getSuccessItemsTable() {
        return this.buildItemsTable(this.property.getSuccessItems(), "recoveredItemsList", false, false);
    }

    public String getFailureItemsTable() {
        return this.buildItemsTable(this.property.getFailureItems(), "failedItemsList", true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getItems() {
        List<Node> itemNodes = null;
        UserTransaction tx = null;
        ResultSet results = null;
        try {
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            if (this.getArchiveRootRef() != null && this.property.isShowItems()) {
                String query = this.buildSearchQuery();
                SearchParameters sp = new SearchParameters();
                sp.setLanguage("lucene");
                sp.setQuery(query);
                sp.addStore(this.getArchiveRootRef().getStoreRef());
                results = this.getSearchService().query(sp);
                itemNodes = new ArrayList<Node>(results.length());
            }
            if (results != null && results.length() != 0) {
                for (ResultSetRow row : results) {
                    NodeRef nodeRef = row.getNodeRef();
                    if (!this.getNodeService().exists(nodeRef)) continue;
                    QName type = this.getNodeService().getType(nodeRef);
                    MapNode node = new MapNode(nodeRef, this.getNodeService(), false);
                    node.addPropertyResolver("locationPath", this.resolverLocationPath);
                    node.addPropertyResolver("displayPath", this.resolverDisplayPath);
                    node.addPropertyResolver("deletedDate", this.resolverDeletedDate);
                    node.addPropertyResolver("deletedBy", this.resolverDeletedBy);
                    node.addPropertyResolver("isFolder", this.resolverIsFolder);
                    if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_FOLDER) && !this.getDictionaryService().isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER)) {
                        node.addPropertyResolver("typeIcon", this.resolverSmallIcon);
                    } else {
                        node.addPropertyResolver("typeIcon", this.resolverFileType16);
                    }
                    itemNodes.add(node);
                }
            }
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        this.property.setListedItems(itemNodes != null ? itemNodes : Collections.emptyList());
        return this.property.getListedItems();
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    public void searchName(ActionEvent event) {
        this.contextUpdated();
        this.property.setShowItems(true);
        this.property.setFullTextSearch(false);
    }

    public void searchContent(ActionEvent event) {
        this.contextUpdated();
        this.property.setShowItems(true);
        this.property.setFullTextSearch(true);
    }

    public void clearSearch(ActionEvent event) {
        this.contextUpdated();
        this.property.setSearchText(null);
        this.property.setShowItems(true);
    }

    public void setupItemAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            try {
                NodeRef ref = new NodeRef(this.getArchiveRootRef().getStoreRef(), id);
                Node node = new Node(ref);
                node.addPropertyResolver("locationPath", this.resolverLocationPath);
                node.addPropertyResolver("deletedDate", this.resolverDeletedDate);
                node.addPropertyResolver("deletedBy", this.resolverDeletedBy);
                node.addPropertyResolver("isFolder", this.resolverIsFolder);
                node.addPropertyResolver("mimetype", this.resolverMimetype);
                node.addPropertyResolver("size", this.resolverSize);
                node.addPropertyResolver("encoding", this.resolverEncoding);
                if (this.getDictionaryService().isSubClass(node.getType(), ContentModel.TYPE_FOLDER) && !this.getDictionaryService().isSubClass(node.getType(), ContentModel.TYPE_SYSTEM_FOLDER)) {
                    node.addPropertyResolver("icon", this.resolverLargeIcon);
                } else {
                    node.addPropertyResolver("icon", this.resolverFileType32);
                }
                this.property.setItem(node);
                this.property.setDestination(null);
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
            }
        } else {
            this.property.setItem(null);
        }
        this.contextUpdated();
    }

    public void setupListAction(ActionEvent event) {
        this.property.setDestination(null);
        this.contextUpdated();
    }

    public String close() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        return OUTCOME_DIALOGCLOSE;
    }

    public void setupTrashcan(ActionEvent event) {
        this.contextUpdated();
    }

    public void dateFilterChanged(ActionEvent event) {
        UIModeList filterComponent = (UIModeList)event.getComponent();
        this.property.setDateFilter(filterComponent.getValue().toString());
        this.contextUpdated();
        this.property.setShowItems(true);
    }

    public void userFilterChanged(ActionEvent event) {
        UIModeList filterComponent = (UIModeList)event.getComponent();
        this.property.setUserFilter(filterComponent.getValue().toString());
        this.contextUpdated();
        this.property.setShowItems(true);
    }

    private NodeRef getArchiveRootRef() {
        if (this.property.getArchiveRootRef() == null) {
            this.property.setArchiveRootRef(this.property.getNodeArchiveService().getStoreArchiveNode(Repository.getStoreRef()));
        }
        return this.property.getArchiveRootRef();
    }

    private String buildSearchQuery() {
        String safeText;
        String query = this.property.getSearchText() == null || this.property.getSearchText().length() == 0 ? String.format(SEARCH_ALL, this.property.getArchiveRootRef(), ContentModel.ASPECT_ARCHIVED) : ((safeText = LuceneQueryParser.escape((String)this.property.getSearchText())).indexOf(32) == -1 ? (this.property.isFullTextSearch() ? String.format(SEARCH_TEXT, this.property.getArchiveRootRef(), ContentModel.ASPECT_ARCHIVED, safeText) : String.format(SEARCH_NAME, this.property.getArchiveRootRef(), ContentModel.ASPECT_ARCHIVED, safeText, safeText)) : (this.property.isFullTextSearch() ? String.format(SEARCH_TEXT_QUOTED, this.property.getArchiveRootRef(), ContentModel.ASPECT_ARCHIVED, safeText) : String.format(SEARCH_NAME_QUOTED, this.property.getArchiveRootRef(), ContentModel.ASPECT_ARCHIVED, safeText)));
        String username = null;
        if (!this.isAdminUser()) {
            username = Application.getCurrentUser(FacesContext.getCurrentInstance()).getUserName();
        } else if (FILTER_USER_USER.equals(this.property.getUserFilter())) {
            username = this.property.getUserSearchText();
        }
        if (username != null && username.length() != 0) {
            query = String.format(SEARCH_USERPREFIX, username) + query;
        }
        if (!FILTER_DATE_ALL.equals(this.property.getDateFilter())) {
            Date toDate = new Date();
            Date fromDate = null;
            if (FILTER_DATE_TODAY.equals(this.property.getDateFilter())) {
                fromDate = new Date(toDate.getYear(), toDate.getMonth(), toDate.getDate(), 0, 0, 0);
            } else if (FILTER_DATE_WEEK.equals(this.property.getDateFilter())) {
                fromDate = new Date(toDate.getTime() - 604800000L);
            } else if (FILTER_DATE_MONTH.equals(this.property.getDateFilter())) {
                fromDate = new Date(toDate.getTime() - 2592000000L);
            }
            if (fromDate != null) {
                SimpleDateFormat df = CachingDateFormat.getDateFormat();
                String strFromDate = LuceneQueryParser.escape((String)df.format(fromDate));
                String strToDate = LuceneQueryParser.escape((String)df.format(toDate));
                StringBuilder buf = new StringBuilder(128);
                buf.append("@").append(DATE_ATTR).append(":").append("[").append(strFromDate).append(" TO ").append(strToDate).append("] AND ");
                query = buf.toString() + query;
            }
        }
        return query;
    }

    protected void saveReportDetail(List<RestoreNodeReport> reports) {
        this.property.setSuccessItems(new ArrayList<Node>(reports.size()));
        this.property.setFailureItems(new ArrayList<Node>(reports.size()));
        for (RestoreNodeReport report : reports) {
            Node node;
            if (RestoreNodeReport.RestoreStatus.SUCCESS == report.getStatus()) {
                node = new Node(report.getRestoredNodeRef());
                node.getProperties().put(PROP_RECOVERSTATUS, report.getStatus());
                this.property.getSuccessItems().add(node);
                continue;
            }
            node = new Node(report.getArchivedNodeRef());
            node.getProperties().put(PROP_RECOVERSTATUS, report.getStatus());
            this.property.getFailureItems().add(node);
        }
    }

    private String buildItemsTable(List<Node> items, String cssClass, boolean report, boolean archivedPath) {
        FacesContext fc = FacesContext.getCurrentInstance();
        String contextPath = fc.getExternalContext().getRequestContextPath();
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table width=100% cellspacing=1 cellpadding=1 border=0 class='");
        buf.append(cssClass);
        buf.append("'>");
        buf.append("<tr style='border-bottom:1px'><th></th><th align=left><b>");
        buf.append(Application.getMessage(fc, MSG_NAME));
        buf.append("</b></th>");
        if (report) {
            buf.append("<th align=left>");
            buf.append(Application.getMessage(fc, MSG_RECOVERY_REASON));
            buf.append("</th>");
        } else {
            buf.append("<th align=left><b>");
            buf.append(Application.getMessage(fc, MSG_LOCATION));
            buf.append("</b></th>");
        }
        buf.append("</tr>");
        for (Node node : items) {
            String img;
            buf.append("<tr><td width=16>");
            if (this.getDictionaryService().isSubClass(node.getType(), ContentModel.TYPE_FOLDER)) {
                String icon = (String)node.getProperties().get("app:icon");
                img = "/images/icons/" + (icon != null ? icon + "-16.gif" : "space_small.gif");
            } else {
                img = FileTypeImageUtils.getFileTypeImage((String)node.getName(), (boolean)true);
            }
            buf.append("<img width=16 height=16 alt='' src='").append(contextPath).append(img).append("'>");
            buf.append("</td><td>");
            buf.append(Utils.encode((String)node.getName()));
            buf.append("</td>");
            if (report) {
                String msg;
                buf.append("<td>");
                switch ((RestoreNodeReport.RestoreStatus)node.getProperties().get(PROP_RECOVERSTATUS)) {
                    case FAILURE_INVALID_PARENT: {
                        msg = MSG_RECOVERED_ITEM_PARENT_S;
                        break;
                    }
                    case FAILURE_PERMISSION: {
                        msg = MSG_RECOVERED_ITEM_PERMISSION_S;
                        break;
                    }
                    case FAILURE_INTEGRITY: {
                        msg = MSG_RECOVERED_ITEM_INTEGRITY_S;
                        break;
                    }
                    default: {
                        msg = MSG_RECOVERED_ITEM_FAILURE_S;
                    }
                }
                buf.append(Application.getMessage(fc, msg));
                buf.append("</td>");
            } else {
                buf.append("<td>");
                if (archivedPath) {
                    ChildAssociationRef childRef = (ChildAssociationRef)node.getProperties().get(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
                    if (this.getNodeService().exists(childRef.getParentRef())) {
                        buf.append(Utils.encode((String)Repository.getNamePath(this.getNodeService(), this.getNodeService().getPath(childRef.getParentRef()), null, "/", null)));
                    }
                } else {
                    buf.append(Utils.encode((String)Repository.getNamePath(this.getNodeService(), this.getNodeService().getPath(node.getNodeRef()), null, "/", null)));
                }
                buf.append("</td>");
            }
            buf.append("</tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    private boolean isAdminUser() {
        return Application.getCurrentUser(FacesContext.getCurrentInstance()).isAdmin();
    }

    @Override
    public void contextUpdated() {
        if (this.property.getItemsRichList() != null) {
            this.property.getItemsRichList().setValue(null);
        }
        this.property.setShowItems(false);
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    @Override
    public String cancel() {
        this.close();
        return super.cancel();
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }
}

