/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.users.UsersDialog;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

public class ChangePasswordDialog
extends UsersDialog {
    private static final long serialVersionUID = -1570967895811499123L;
    private static final String MSG_FINISH_BUTTON = "finish_button";

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        String result = this.changePasswordOK(outcome, context);
        if (result == null) {
            this.isFinished = false;
        }
        return result;
    }

    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_FINISH_BUTTON);
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String changePasswordOK(String newOutcome, FacesContext newContext) {
        String outcome = newOutcome;
        if (this.properties.getPassword() != null && this.properties.getConfirm() != null && this.properties.getPassword().equals(this.properties.getConfirm())) {
            try {
                String userName = (String)this.properties.getPerson().getProperties().get(ContentModel.PROP_USERNAME);
                this.properties.getAuthenticationService().setAuthentication(userName, this.properties.getPassword().toCharArray());
            }
            catch (Exception e) {
                outcome = null;
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(newContext, "error_generic"), e.getMessage()), e);
                ReportedException.throwIfNecessary(e);
            }
        } else {
            outcome = null;
            Utils.addErrorMessage(Application.getMessage(newContext, "error_password_match"));
        }
        return outcome;
    }
}

