/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.users.CreateUserWizard;
import org.alfresco.web.bean.users.UsersBeanProperties;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditUserWizard
extends CreateUserWizard {
    private static final long serialVersionUID = 7529989488476324511L;
    private static Log logger = LogFactory.getLog(EditUserWizard.class);
    protected UsersBeanProperties properties;

    public void setProperties(UsersBeanProperties properties) {
        this.properties = properties;
    }

    @Override
    public void init(Map<String, String> arg0) {
        super.init(arg0);
        Map<String, Object> props = this.properties.getPerson().getProperties();
        this.firstName = (String)props.get("firstName");
        this.lastName = (String)props.get("lastName");
        this.userName = (String)props.get("userName");
        this.email = (String)props.get("email");
        this.companyId = (String)props.get("organizationId");
        this.organisation = (String)props.get("organization");
        this.jobtitle = (String)props.get("jobtitle");
        this.location = (String)props.get("location");
        this.presenceProvider = (String)props.get("presenceProvider");
        this.presenceUsername = (String)props.get("presenceUsername");
        this.sizeQuota = (Long)props.get("sizeQuota");
        if (this.sizeQuota != null && this.sizeQuota == -1L) {
            this.sizeQuota = null;
        }
        if (this.sizeQuota != null) {
            Pair<Long, String> size = this.convertFromBytes(this.sizeQuota);
            this.sizeQuota = (Long)size.getFirst();
            this.sizeQuotaUnits = (String)size.getSecond();
        }
        this.homeSpaceLocation = null;
        NodeRef homeFolderRef = (NodeRef)props.get("homeFolder");
        if (homeFolderRef != null && this.getNodeService().exists(homeFolderRef)) {
            ChildAssociationRef childAssocRef = this.getNodeService().getPrimaryParent(homeFolderRef);
            NodeRef parentRef = childAssocRef.getParentRef();
            if (!this.getNodeService().getRootNode(Repository.getStoreRef()).equals((Object)parentRef)) {
                this.homeSpaceLocation = parentRef;
                this.homeSpaceName = Repository.getNameForNode(this.getNodeService(), homeFolderRef);
            } else {
                this.homeSpaceLocation = homeFolderRef;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Edit user home space location: " + this.homeSpaceLocation + " home space name: " + this.homeSpaceName));
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        try {
            NodeRef newHomeFolderRef;
            NodeRef nodeRef = this.properties.getPerson().getNodeRef();
            Map props = this.getNodeService().getProperties(nodeRef);
            props.put(ContentModel.PROP_USERNAME, this.userName);
            props.put(ContentModel.PROP_FIRSTNAME, this.firstName);
            props.put(ContentModel.PROP_LASTNAME, this.lastName);
            NodeRef oldHomeFolderRef = (NodeRef)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_HOMEFOLDER);
            boolean moveHomeSpace = false;
            boolean renameHomeSpace = false;
            if (oldHomeFolderRef != null && this.getNodeService().exists(oldHomeFolderRef)) {
                ChildAssociationRef childAssocRef = this.getNodeService().getPrimaryParent(oldHomeFolderRef);
                NodeRef currentHomeSpaceLocation = childAssocRef.getParentRef();
                if (this.homeSpaceName.length() != 0) {
                    String oldHomeSpaceName;
                    if (!(currentHomeSpaceLocation.equals((Object)this.homeSpaceLocation) || oldHomeFolderRef.equals((Object)this.homeSpaceLocation) || currentHomeSpaceLocation.equals((Object)this.getCompanyHomeSpace()) || currentHomeSpaceLocation.equals((Object)this.getDefaultHomeSpace()))) {
                        moveHomeSpace = true;
                    }
                    if (!(oldHomeSpaceName = Repository.getNameForNode(this.getNodeService(), oldHomeFolderRef)).equals(this.homeSpaceName) && !oldHomeFolderRef.equals((Object)this.homeSpaceLocation)) {
                        renameHomeSpace = true;
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Moving space: " + moveHomeSpace + "  and renaming space: " + renameHomeSpace));
            }
            if (!moveHomeSpace && !renameHomeSpace) {
                newHomeFolderRef = this.homeSpaceLocation != null && this.homeSpaceName.length() != 0 ? this.createHomeSpace(this.homeSpaceLocation.getId(), this.homeSpaceName, false) : (this.homeSpaceLocation != null ? this.homeSpaceLocation : this.getCompanyHomeSpace());
            } else {
                if (moveHomeSpace) {
                    this.getNodeService().moveNode(oldHomeFolderRef, this.homeSpaceLocation, ContentModel.ASSOC_CONTAINS, this.getNodeService().getPrimaryParent(oldHomeFolderRef).getQName());
                }
                newHomeFolderRef = oldHomeFolderRef;
                if (renameHomeSpace) {
                    this.getNodeService().setProperty(newHomeFolderRef, ContentModel.PROP_NAME, (Serializable)((Object)this.homeSpaceName));
                }
            }
            props.put(ContentModel.PROP_HOMEFOLDER, newHomeFolderRef);
            props.put(ContentModel.PROP_EMAIL, this.email);
            props.put(ContentModel.PROP_ORGID, this.companyId);
            props.put(ContentModel.PROP_ORGANIZATION, this.organisation);
            props.put(ContentModel.PROP_JOBTITLE, this.jobtitle);
            props.put(ContentModel.PROP_LOCATION, this.location);
            props.put(ContentModel.PROP_PRESENCEPROVIDER, this.presenceProvider);
            props.put(ContentModel.PROP_PRESENCEUSERNAME, this.presenceUsername);
            this.getNodeService().setProperties(nodeRef, props);
            if (this.sizeQuota != null && this.sizeQuota < 0L) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_negative_quota"), this.sizeQuota));
                outcome = null;
            } else {
                this.putSizeQuotaProperty(this.userName, this.sizeQuota, this.sizeQuotaUnits);
            }
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_person"), e.getMessage()), e);
            outcome = null;
            ReportedException.throwIfNecessary(e);
        }
        if (outcome == null) {
            this.isFinished = false;
        }
        return outcome;
    }

    @Override
    public Map getPersonPropertiesImmutability() {
        return this.properties.getImmutability();
    }
}

