/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.dialog.NavigationSupport;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AVMDetailsBean
extends BaseDialogBean
implements NavigationSupport {
    private static final long serialVersionUID = -4895328117656471680L;
    private transient NodeService nodeService;
    private transient AVMService avmService;
    protected AVMBrowseBean avmBrowseBean;
    protected Map<String, Boolean> panels = new HashMap<String, Boolean>(4, 1.0f);

    @Override
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public Map<String, Boolean> getPanels() {
        return this.panels;
    }

    public void setPanels(Map<String, Boolean> panels) {
        this.panels = panels;
    }

    public abstract AVMNode getAvmNode();

    public String getPath() {
        return this.getAvmNode().getPath();
    }

    public String getName() {
        return this.getAvmNode().getName();
    }

    public String getNodeRefUrl() {
        return this.getAvmNode().getNodeRef().toString();
    }

    public boolean getIsBrowseList() {
        return !this.avmBrowseBean.isCurrentPathNull();
    }

    protected abstract List<AVMNode> getNodes();

    public void expandPanel(ActionEvent event) {
        if (event instanceof UIPanel.ExpandedEvent) {
            String id = event.getComponent().getId();
            this.panels.put(id, ((UIPanel.ExpandedEvent)event).State);
        }
    }

    @Override
    public void nextItem(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String path = params.get("id");
        if (path != null && path.length() != 0) {
            this.avmBrowseBean.setupContentAction(this.getCurrentItemId(), false);
            List<AVMNode> nodes = this.getNodes();
            if (nodes.size() > 1) {
                for (int i = 0; i < nodes.size(); ++i) {
                    if (!path.equals(nodes.get(i).get("id"))) continue;
                    AVMNode next = i != nodes.size() - 1 ? nodes.get(i + 1) : nodes.get(0);
                    this.avmBrowseBean.setupContentAction(next.getPath(), false);
                    break;
                }
            }
        }
    }

    @Override
    public void previousItem(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String path = params.get("id");
        if (path != null && path.length() != 0) {
            this.avmBrowseBean.setupContentAction(this.getCurrentItemId(), false);
            List<AVMNode> nodes = this.getNodes();
            if (nodes.size() > 1) {
                for (int i = 0; i < nodes.size(); ++i) {
                    if (!path.equals(nodes.get(i).get("id"))) continue;
                    AVMNode previous = i != 0 ? nodes.get(i - 1) : nodes.get(nodes.size() - 1);
                    this.avmBrowseBean.setupContentAction(previous.getPath(), false);
                    break;
                }
            }
        }
    }
}

