/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.CreateFolderDialog;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLayeredFolderDialog
extends CreateFolderDialog {
    private static final long serialVersionUID = -2922225296046521490L;
    private static final Log logger = LogFactory.getLog(CreateLayeredFolderDialog.class);
    protected String targetStore;
    protected String targetPath;
    protected List<SelectItem> webProjects;
    protected transient WebProjectService wpService;
    protected transient AVMService avmService;

    public void setWebProjectService(WebProjectService wpService) {
        this.wpService = wpService;
    }

    protected WebProjectService getWebProjectService() {
        if (this.wpService == null) {
            this.wpService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWebProjectService();
        }
        return this.wpService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.targetStore = null;
        this.targetPath = null;
        this.webProjects = null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        AVMNodeDescriptor nodeDesc;
        String parent = this.avmBrowseBean.getCurrentPath();
        if (!this.targetPath.startsWith("/")) {
            this.targetPath = "/" + this.targetPath;
        }
        String layeredPath = AVMUtil.buildSandboxRootPath(this.targetStore) + this.targetPath;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating layered folder named '" + this.name + "' in '" + parent + "' pointing to '" + layeredPath + "'"));
        }
        if ((nodeDesc = this.getAvmService().lookup(-1, layeredPath)) != null) {
            this.getAvmService().createLayeredDirectory(layeredPath, parent, this.name);
            String newDirPath = parent + "/" + this.name;
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef((int)-1, (String)newDirPath);
            this.getNodeService().addAspect(nodeRef, ApplicationModel.ASPECT_UIFACETS, null);
            if (this.title != null && this.title.length() != 0) {
                this.getAvmService().setNodeProperty(newDirPath, ContentModel.PROP_TITLE, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)this.title)));
            }
            String desc = MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "shared_from"), layeredPath);
            this.getAvmService().setNodeProperty(newDirPath, ContentModel.PROP_DESCRIPTION, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)desc)));
        } else {
            String pattern = Application.getMessage(context, "target_does_not_exists");
            Utils.addErrorMessage(MessageFormat.format(pattern, this.targetPath));
        }
        return outcome;
    }

    public List<SelectItem> getWebProjects() {
        if (this.webProjects == null) {
            String thisStoreName = this.avmBrowseBean.getWebProject().getStagingStore();
            List wpInfos = this.getWebProjectService().listWebProjects();
            this.webProjects = new ArrayList<SelectItem>(wpInfos.size());
            for (WebProjectInfo wpInfo : wpInfos) {
                String name = wpInfo.getName();
                String dns = wpInfo.getStoreId();
                if (thisStoreName.equals(dns)) continue;
                this.webProjects.add(new SelectItem((Object)dns, name));
            }
            QuickSort sorter = new QuickSort(this.webProjects, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.webProjects;
    }

    public void setTargetStore(String targetStore) {
        this.targetStore = targetStore;
    }

    public String getTargetStore() {
        return this.targetStore;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }
}

