/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteDeploymentReportsDialog
extends BaseDialogBean {
    protected AVMBrowseBean avmBrowseBean;
    private static final long serialVersionUID = -3702005115210010993L;
    private static final Log logger = LogFactory.getLog(DeleteDeploymentReportsDialog.class);

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeService nodeService = this.getNodeService();
        NodeRef websiteRef = this.avmBrowseBean.getWebsite().getNodeRef();
        List deployReportRefs = nodeService.getChildAssocs(websiteRef, (QNamePattern)WCMAppModel.ASSOC_DEPLOYMENTREPORT, RegexQNamePattern.MATCH_ALL);
        int count = deployReportRefs.size();
        for (ChildAssociationRef ref : deployReportRefs) {
            NodeRef report = ref.getChildRef();
            if (report == null) continue;
            nodeService.deleteNode(report);
        }
        List deployAttemptRefs = nodeService.getChildAssocs(websiteRef, (QNamePattern)WCMAppModel.ASSOC_DEPLOYMENTATTEMPT, RegexQNamePattern.MATCH_ALL);
        count += deployAttemptRefs.size();
        for (ChildAssociationRef ref : deployAttemptRefs) {
            NodeRef attempt = ref.getChildRef();
            if (attempt == null) continue;
            nodeService.deleteNode(attempt);
        }
        nodeService.removeProperty(websiteRef, WCMAppModel.PROP_DEPLOYTO);
        nodeService.removeProperty(websiteRef, WCMAppModel.PROP_SELECTEDDEPLOYTO);
        nodeService.removeProperty(websiteRef, WCMAppModel.PROP_SELECTEDDEPLOYVERSION);
        Map request = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        request.remove("_alfBeenDeployedResult");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed " + count + " previous deployment attempts"));
        }
        return "dialog:close:browseWebsite";
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "yes");
    }

    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "no");
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public String getConfirmMessage() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "delete_reports_confirm");
    }
}

