/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.wcm.DeploymentUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseTestServerDialog
extends BaseDialogBean {
    protected String store;
    private static final long serialVersionUID = -3702005115210010993L;
    private static final Log logger = LogFactory.getLog(ReleaseTestServerDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.store = parameters.get("store");
        if (this.store == null || this.store.length() == 0) {
            throw new IllegalArgumentException("store parameter is mandatory");
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        WebApplicationContext wac = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context);
        NodeService unprotectedNodeService = (NodeService)wac.getBean("nodeService");
        List<NodeRef> testServers = DeploymentUtil.findAllocatedTestServers(this.store);
        for (NodeRef testServer : testServers) {
            unprotectedNodeService.setProperty(testServer, WCMAppModel.PROP_DEPLOYSERVERALLOCATEDTO, null);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Released test server '" + testServer + "' from store: " + this.store));
        }
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "yes");
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "no");
    }

    public String getConfirmMessage() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "release_server_confirm");
    }
}

