/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;

public class RevertSelectedDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -8432152646736206685L;
    private static final String MSG_REVERTSELECTED_SUCCESS = "revertselected_success";
    protected AVMBrowseBean avmBrowseBean;
    private transient SandboxService sbService;

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setSandboxService(SandboxService sbService) {
        this.sbService = sbService;
    }

    protected SandboxService getSandboxService() {
        if (this.sbService == null) {
            this.sbService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSandboxService();
        }
        return this.sbService;
    }

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        String userSandboxId = this.avmBrowseBean.getSandbox();
        List<AVMNodeDescriptor> selected = this.avmBrowseBean.getSelectedSandboxItems();
        if (selected != null && selected.size() > 0) {
            ArrayList<String> relativePaths = new ArrayList<String>(selected.size());
            for (AVMNodeDescriptor node : selected) {
                relativePaths.add(AVMUtil.getStoreRelativePath(node.getPath()));
            }
            this.getSandboxService().revertList(userSandboxId, relativePaths);
            String msg = MessageFormat.format(Application.getMessage(context, MSG_REVERTSELECTED_SUCCESS), this.avmBrowseBean.getUsername());
            FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
            context.addMessage("website:sandboxes-panel", facesMsg);
        }
        return outcome;
    }

    public String getConfirmMessage() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "revert_selected_confirm");
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }
}

