/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.ManagePermissionsDialog;
import org.alfresco.web.bean.wcm.UpdatePermissionsDialog;
import org.alfresco.web.bean.wcm.WCMPermissionsUtils;
import org.alfresco.web.ui.common.SortableSelectItem;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIGenericPicker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPermissionsDialog
extends UpdatePermissionsDialog {
    private static final long serialVersionUID = -8139619811033232880L;
    private static Log logger = LogFactory.getLog(SetPermissionsDialog.class);
    private static final String MSG_USERS = "users";
    private static final String MSG_GROUPS = "groups";
    private static final String MSG_SET_PERMS_FOR = "set_permissions_title";
    private transient AuthorityService authorityService;
    private transient PersonService personService;
    private transient DataModel userPermsDataModel = null;
    private List<AVMNodeDescriptor> childList = null;
    private List<UserGroupPerm> userGroupPerms = null;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    protected AuthorityService getAuthorityService() {
        if (this.authorityService == null) {
            this.authorityService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService();
        }
        return this.authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setActiveNode(this.getAvmBrowseBean().getAvmActionNode());
        this.userGroupPerms = new ArrayList<UserGroupPerm>(8);
        this.userPermsDataModel = null;
        this.childList = new ArrayList<AVMNodeDescriptor>();
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.userGroupPerms.size() == 0;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String pattern = Application.getMessage(fc, MSG_SET_PERMS_FOR);
        return MessageFormat.format(pattern, this.getActiveNode().getName());
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (this.userGroupPerms.size() > 0) {
            this.childList.add(this.getActiveNode().getDescriptor());
            this.setPermissions(this.getActiveNode().getDescriptor());
            this.createLock(this.getActiveNode());
        }
        return outcome;
    }

    private void setPermissions(AVMNodeDescriptor node) {
        block0: for (int i = 0; i < this.userGroupPerms.size(); ++i) {
            UserGroupPerm userGroupPerm = this.userGroupPerms.get(i);
            String authority = userGroupPerm.getAuthority();
            Set<String> perms = ManagePermissionsDialog.getPermissionsForType();
            for (String permission : perms) {
                if (!userGroupPerm.getPermission().equals(permission)) continue;
                this.getPermissionService().setPermission(AVMNodeConverter.ToNodeRef((int)-1, (String)node.getPath()), authority, permission, true);
                if (!logger.isDebugEnabled()) continue block0;
                logger.debug((Object)("permission setted:" + permission));
                continue block0;
            }
        }
    }

    public SelectItem[] getFilters() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        return new SelectItem[]{new SelectItem((Object)"0", bundle.getString(MSG_USERS)), new SelectItem((Object)"1", bundle.getString(MSG_GROUPS))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectItem[] pickerCallback(int filterIndex, String contains) {
        Object[] items;
        FacesContext context = FacesContext.getCurrentInstance();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            ArrayList<SortableSelectItem> results = new ArrayList<SortableSelectItem>();
            if (filterIndex == 0) {
                List nodes;
                String term = LuceneQueryParser.escape((String)contains.trim());
                StringBuilder query = new StringBuilder(128);
                Utils.generatePersonSearch(query, term);
                ResultSet resultSet = Repository.getServiceRegistry(context).getSearchService().query(Repository.getStoreRef(), "lucene", query.toString());
                try {
                    nodes = resultSet.getNodeRefs();
                }
                finally {
                    resultSet.close();
                }
                for (int index = 0; index < nodes.size(); ++index) {
                    NodeRef personRef = (NodeRef)nodes.get(index);
                    String firstName = (String)((Object)this.getNodeService().getProperty(personRef, ContentModel.PROP_FIRSTNAME));
                    String lastName = (String)((Object)this.getNodeService().getProperty(personRef, ContentModel.PROP_LASTNAME));
                    String username = (String)((Object)this.getNodeService().getProperty(personRef, ContentModel.PROP_USERNAME));
                    if (username == null) continue;
                    SortableSelectItem item = new SortableSelectItem(username, firstName + " " + lastName + " [" + username + "]", lastName);
                    results.add(item);
                }
            } else {
                String term = "*" + contains.trim() + "*";
                Set groups = this.getAuthorityService().findAuthorities(AuthorityType.GROUP, null, false, term, "APP.DEFAULT");
                groups.addAll(this.getAuthorityService().getAllAuthorities(AuthorityType.EVERYONE));
                for (String group : groups) {
                    String groupDisplayName = this.getAuthorityService().getAuthorityDisplayName(group);
                    if (groupDisplayName == null || groupDisplayName.length() == 0) {
                        groupDisplayName = group.substring("GROUP_".length());
                    }
                    results.add(new SortableSelectItem(group, groupDisplayName, groupDisplayName));
                }
            }
            items = new SelectItem[results.size()];
            results.toArray(items);
            Arrays.sort(items);
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            items = new SelectItem[]{};
        }
        return items;
    }

    public void addSelection(ActionEvent event) {
        String permission;
        UIGenericPicker picker = (UIGenericPicker)event.getComponent().findComponent("picker");
        UISelectOne permissionPicker = (UISelectOne)event.getComponent().findComponent("permissions");
        String[] results = picker.getSelectedResults();
        if (results != null && (permission = (String)permissionPicker.getValue()) != null) {
            for (int i = 0; i < results.length; ++i) {
                this.addAuthorityWithPerm(results[i], permission);
            }
        }
    }

    public void addAuthorityWithPerm(String authority, String permsission) {
        boolean foundExisting = false;
        for (int n = 0; n < this.userGroupPerms.size(); ++n) {
            UserGroupPerm wrapper = this.userGroupPerms.get(n);
            if (!authority.equals(wrapper.getAuthority()) || !permsission.equals(wrapper.getPermission())) continue;
            foundExisting = true;
            break;
        }
        if (!foundExisting) {
            StringBuilder label = new StringBuilder(64);
            AuthorityType authType = AuthorityType.getAuthorityType((String)authority);
            if (authType == AuthorityType.GUEST || authType == AuthorityType.USER) {
                if (authType == AuthorityType.GUEST || this.getPersonService().personExists(authority)) {
                    label.append(this.buildLabelForUserAuthorityPerm(authority, permsission));
                }
            } else {
                label.append(this.buildLabelForGroupAuthorityPerm(authority, permsission));
            }
            this.userGroupPerms.add(new UserGroupPerm(authority, permsission, label.toString()));
        }
    }

    public void removeSelection(ActionEvent event) {
        UserGroupPerm wrapper = (UserGroupPerm)this.getUserPermsDataModel().getRowData();
        if (wrapper != null) {
            this.userGroupPerms.remove(wrapper);
        }
    }

    public DataModel getUserPermsDataModel() {
        if (this.userPermsDataModel == null) {
            this.userPermsDataModel = new ListDataModel();
        }
        if (this.userPermsDataModel.getWrappedData() == null) {
            this.userPermsDataModel.setWrappedData(this.userGroupPerms);
        }
        return this.userPermsDataModel;
    }

    public String buildLabelForUserAuthorityPerm(String authority, String role) {
        NodeRef ref = this.getPersonService().getPerson(authority);
        String firstName = (String)((Object)this.getNodeService().getProperty(ref, ContentModel.PROP_FIRSTNAME));
        String lastName = (String)((Object)this.getNodeService().getProperty(ref, ContentModel.PROP_LASTNAME));
        StringBuilder buf = new StringBuilder(100);
        buf.append(firstName).append(" ").append(lastName != null ? lastName : "").append(" (").append(Application.getMessage(FacesContext.getCurrentInstance(), role)).append(")");
        return buf.toString();
    }

    public String buildLabelForGroupAuthorityPerm(String authority, String role) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(authority.substring("GROUP_".length())).append(" (").append(Application.getMessage(FacesContext.getCurrentInstance(), role)).append(")");
        return buf.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.userPermsDataModel = new ListDataModel();
        this.userPermsDataModel.setWrappedData(this.userGroupPerms);
    }

    public SelectItem[] getPermissions() {
        return WCMPermissionsUtils.getPermissions();
    }

    public static class UserGroupPerm
    implements Serializable {
        private static final long serialVersionUID = -1546705703700113861L;
        private String authority;
        private String permission;
        private String label;

        public UserGroupPerm(String authority, String permission, String label) {
            this.authority = authority;
            this.permission = permission;
            this.label = label;
        }

        public String getAuthority() {
            return this.authority;
        }

        public String getPermission() {
            return this.permission;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

