/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wizard;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractWizardBean
implements Serializable {
    private static Log logger = LogFactory.getLog(AbstractWizardBean.class);
    private static final String MSG_NOT_SET = "value_not_set";
    protected static final String FINISH_OUTCOME = "finish";
    protected static final String CANCEL_OUTCOME = "cancel";
    protected static final String DEFAULT_INSTRUCTION_ID = "default_instruction";
    protected static final String SUMMARY_TITLE_ID = "summary";
    protected static final String SUMMARY_DESCRIPTION_ID = "summary_desc";
    protected int currentStep = 1;
    protected boolean editMode = false;
    private transient NodeService nodeService;
    private transient FileFolderService fileFolderService;
    private transient SearchService searchService;
    protected NavigationBean navigator;
    protected BrowseBean browseBean;

    public abstract String getWizardDescription();

    public abstract String getWizardTitle();

    public abstract String getStepTitle();

    public abstract String getStepDescription();

    public abstract String getStepInstructions();

    protected abstract String determineOutcomeForStep(int var1);

    public abstract String finish();

    public void startWizard(ActionEvent event) {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        this.editMode = false;
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started wizard : " + this.getWizardTitle()));
        }
    }

    public void startWizardForEdit(ActionEvent event) {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        this.editMode = true;
        this.init();
        this.populate();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started wizard : " + this.getWizardTitle() + " for editing"));
        }
    }

    public boolean isInEditMode() {
        return this.editMode;
    }

    public String next() {
        ++this.currentStep;
        String outcome = this.determineOutcomeForStep(this.currentStep);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("current step is now: " + this.currentStep));
            logger.debug((Object)("Next outcome: " + outcome));
        }
        return outcome;
    }

    public String back() {
        --this.currentStep;
        String outcome = this.determineOutcomeForStep(this.currentStep);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("current step is now: " + this.currentStep));
            logger.debug((Object)("Back outcome: " + outcome));
        }
        return outcome;
    }

    public String cancel() {
        this.init();
        return CANCEL_OUTCOME;
    }

    public void init() {
        this.currentStep = 1;
    }

    public void populate() {
    }

    public NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    protected FileFolderService getFileFolderService() {
        if (this.fileFolderService == null) {
            this.fileFolderService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getFileFolderService();
        }
        return this.fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    protected SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public NavigationBean getNavigator() {
        return this.navigator;
    }

    public void setNavigator(NavigationBean navigator) {
        this.navigator = navigator;
    }

    public BrowseBean getBrowseBean() {
        return this.browseBean;
    }

    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    protected String buildSummary(String[] labels, String[] values) {
        if (labels == null || values == null || labels.length != values.length) {
            throw new IllegalArgumentException("Labels and Values passed to summary must be valid and of equal length.");
        }
        String msg = Application.getMessage(FacesContext.getCurrentInstance(), MSG_NOT_SET);
        String notSetMsg = "&lt;" + msg + "&gt;";
        StringBuilder buf = new StringBuilder(256);
        buf.append("<table cellspacing='4' cellpadding='2' border='0' class='summary'>");
        for (int i = 0; i < labels.length; ++i) {
            String value = values[i];
            buf.append("<tr><td valign='top'><b>");
            buf.append(labels[i]);
            buf.append(":</b></td><td>");
            buf.append(value != null ? Utils.encode((String)value) : notSetMsg);
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }
}

