/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wizard;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.validator.ValidatorException;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.AbstractWizardBean;
import org.alfresco.web.config.ClientConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.EmailValidator;

public class NewUserWizard
extends AbstractWizardBean {
    private static final long serialVersionUID = -4608152661068880638L;
    private static Log logger = LogFactory.getLog(NewUserWizard.class);
    private static final String WIZARD_TITLE_NEW_ID = "new_user_title";
    private static final String WIZARD_DESC_NEW_ID = "new_user_desc";
    private static final String WIZARD_TITLE_EDIT_ID = "new_user_title_edit";
    private static final String WIZARD_DESC_EDIT_ID = "new_user_desc_edit";
    private static final String STEP1_TITLE_ID = "new_user_step1_title";
    private static final String STEP1_DESCRIPTION_ID = "new_user_step1_desc";
    private static final String STEP2_TITLE_ID = "new_user_step2_title";
    private static final String STEP2_DESCRIPTION_ID = "new_user_step2_desc";
    private static final String FINISH_INSTRUCTION_ID = "new_user_finish_instruction";
    private static final String ERROR = "error_person";
    private static final String MSG_ERROR_MAIL_NOT_VALID = "email_format_is_not_valid";
    private String firstName = null;
    private String lastName = null;
    private String userName = null;
    private String password = null;
    private String confirm = null;
    private String email = null;
    private String companyId = null;
    private String homeSpaceName = "";
    private NodeRef homeSpaceLocation = null;
    private transient MutableAuthenticationService authenticationService;
    private transient NamespaceService namespaceService;
    private transient PermissionService permissionService;
    private transient PersonService personService;
    private TenantService tenantService;
    private transient OwnableService ownableService;
    private Node person = null;
    private NodeRef defaultHomeSpaceRef;
    private NodeRef companyHomeSpaceRef = null;

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    private MutableAuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthenticationService();
        }
        return this.authenticationService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    private NamespaceService getNamespaceService() {
        if (this.namespaceService == null) {
            this.namespaceService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNamespaceService();
        }
        return this.namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    private PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    private PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    private OwnableService getOwnableService() {
        if (this.ownableService == null) {
            this.ownableService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getOwnableService();
        }
        return this.ownableService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void init() {
        super.init();
        this.firstName = "";
        this.lastName = "";
        this.userName = "";
        this.password = "";
        this.confirm = "";
        this.email = "";
        this.companyId = "";
        this.homeSpaceName = "";
        this.homeSpaceLocation = this.getDefaultHomeSpace();
    }

    public void populate() {
        Map<String, Object> props = this.getPerson().getProperties();
        this.firstName = (String)props.get("firstName");
        this.lastName = (String)props.get("lastName");
        this.userName = (String)props.get("userName");
        this.password = "";
        this.confirm = "";
        this.email = (String)props.get("email");
        this.companyId = (String)props.get("organizationId");
        this.homeSpaceLocation = null;
        this.homeSpaceName = "";
        NodeRef homeFolderRef = (NodeRef)props.get("homeFolder");
        if (homeFolderRef != null && this.getNodeService().exists(homeFolderRef)) {
            ChildAssociationRef childAssocRef = this.getNodeService().getPrimaryParent(homeFolderRef);
            NodeRef parentRef = childAssocRef.getParentRef();
            if (!this.getNodeService().getRootNode(Repository.getStoreRef()).equals((Object)parentRef)) {
                this.homeSpaceLocation = parentRef;
                this.homeSpaceName = Repository.getNameForNode(this.getNodeService(), homeFolderRef);
            } else {
                this.homeSpaceLocation = homeFolderRef;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Edit user home space location: " + this.homeSpaceLocation + " home space name: " + this.homeSpaceName));
        }
    }

    public String getWizardDescription() {
        if (this.editMode) {
            return Application.getMessage(FacesContext.getCurrentInstance(), WIZARD_DESC_EDIT_ID);
        }
        return Application.getMessage(FacesContext.getCurrentInstance(), WIZARD_DESC_NEW_ID);
    }

    public String getWizardTitle() {
        if (this.editMode) {
            return Application.getMessage(FacesContext.getCurrentInstance(), WIZARD_TITLE_EDIT_ID);
        }
        return Application.getMessage(FacesContext.getCurrentInstance(), WIZARD_TITLE_NEW_ID);
    }

    public String getStepTitle() {
        String stepTitle = null;
        switch (this.currentStep) {
            case 1: {
                stepTitle = Application.getMessage(FacesContext.getCurrentInstance(), STEP1_TITLE_ID);
                break;
            }
            case 2: {
                stepTitle = Application.getMessage(FacesContext.getCurrentInstance(), STEP2_TITLE_ID);
                break;
            }
            case 3: {
                stepTitle = Application.getMessage(FacesContext.getCurrentInstance(), "summary");
                break;
            }
            default: {
                stepTitle = "";
            }
        }
        return stepTitle;
    }

    public String getStepDescription() {
        String stepDesc = null;
        switch (this.currentStep) {
            case 1: {
                stepDesc = Application.getMessage(FacesContext.getCurrentInstance(), STEP1_DESCRIPTION_ID);
                break;
            }
            case 2: {
                stepDesc = Application.getMessage(FacesContext.getCurrentInstance(), STEP2_DESCRIPTION_ID);
                break;
            }
            case 3: {
                stepDesc = Application.getMessage(FacesContext.getCurrentInstance(), "summary_desc");
                break;
            }
            default: {
                stepDesc = "";
            }
        }
        return stepDesc;
    }

    public String getStepInstructions() {
        String stepInstruction = null;
        switch (this.currentStep) {
            case 3: {
                stepInstruction = Application.getMessage(FacesContext.getCurrentInstance(), FINISH_INSTRUCTION_ID);
                break;
            }
            default: {
                stepInstruction = Application.getMessage(FacesContext.getCurrentInstance(), "default_instruction");
            }
        }
        return stepInstruction;
    }

    protected String determineOutcomeForStep(int step) {
        String outcome = null;
        switch (step) {
            case 1: {
                outcome = "person-properties";
                break;
            }
            case 2: {
                outcome = "user-properties";
                break;
            }
            case 3: {
                outcome = "summary";
                break;
            }
            default: {
                outcome = "cancel";
            }
        }
        return outcome;
    }

    public String finish() {
        String outcome = "finish";
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context);
            tx.begin();
            if (this.editMode) {
                NodeRef newHomeFolderRef;
                NodeRef nodeRef = this.getPerson().getNodeRef();
                Map props = this.getNodeService().getProperties(nodeRef);
                props.put(ContentModel.PROP_USERNAME, this.userName);
                props.put(ContentModel.PROP_FIRSTNAME, this.firstName);
                props.put(ContentModel.PROP_LASTNAME, this.lastName);
                NodeRef oldHomeFolderRef = (NodeRef)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_HOMEFOLDER);
                boolean moveHomeSpace = false;
                boolean renameHomeSpace = false;
                if (oldHomeFolderRef != null && this.getNodeService().exists(oldHomeFolderRef)) {
                    ChildAssociationRef childAssocRef = this.getNodeService().getPrimaryParent(oldHomeFolderRef);
                    NodeRef currentHomeSpaceLocation = childAssocRef.getParentRef();
                    if (this.homeSpaceName.length() != 0) {
                        String oldHomeSpaceName;
                        if (!(currentHomeSpaceLocation.equals((Object)this.homeSpaceLocation) || oldHomeFolderRef.equals((Object)this.homeSpaceLocation) || currentHomeSpaceLocation.equals((Object)this.getCompanyHomeSpace()) || currentHomeSpaceLocation.equals((Object)this.getDefaultHomeSpace()))) {
                            moveHomeSpace = true;
                        }
                        if (!((oldHomeSpaceName = Repository.getNameForNode(this.getNodeService(), oldHomeFolderRef)).equals(this.homeSpaceName) || oldHomeFolderRef.equals((Object)this.homeSpaceLocation) || oldHomeFolderRef.equals((Object)this.defaultHomeSpaceRef))) {
                            renameHomeSpace = true;
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Moving space: " + moveHomeSpace + "  and renaming space: " + renameHomeSpace));
                }
                if (!moveHomeSpace && !renameHomeSpace) {
                    newHomeFolderRef = this.homeSpaceLocation != null && this.homeSpaceName.length() != 0 ? this.createHomeSpace(this.homeSpaceLocation.getId(), this.homeSpaceName, false) : (this.homeSpaceLocation != null ? this.homeSpaceLocation : this.getCompanyHomeSpace());
                } else {
                    if (moveHomeSpace) {
                        this.getNodeService().moveNode(oldHomeFolderRef, this.homeSpaceLocation, ContentModel.ASSOC_CONTAINS, this.getNodeService().getPrimaryParent(oldHomeFolderRef).getQName());
                    }
                    newHomeFolderRef = oldHomeFolderRef;
                    if (renameHomeSpace) {
                        this.getNodeService().setProperty(newHomeFolderRef, ContentModel.PROP_NAME, (Serializable)((Object)this.homeSpaceName));
                    }
                }
                props.put(ContentModel.PROP_HOMEFOLDER, newHomeFolderRef);
                props.put(ContentModel.PROP_EMAIL, this.email);
                props.put(ContentModel.PROP_ORGID, this.companyId);
                this.getNodeService().setProperties(nodeRef, props);
            } else {
                String currentDomain;
                if (this.tenantService.isEnabled() && !(currentDomain = this.tenantService.getCurrentUserDomain()).equals("")) {
                    if (!this.tenantService.isTenantUser(this.userName)) {
                        this.userName = this.tenantService.getDomainUser(this.userName, currentDomain);
                        logger.warn((Object)("Added domain to username: " + this.userName));
                    } else {
                        try {
                            this.tenantService.checkDomainUser(this.userName);
                        }
                        catch (RuntimeException re) {
                            throw new AuthenticationException("User must belong to same domain as admin: " + currentDomain);
                        }
                    }
                }
                if (this.password.equals(this.confirm)) {
                    NodeRef homeSpaceNodeRef;
                    HashMap<QName, String> props = new HashMap<QName, String>(7, 1.0f);
                    props.put(ContentModel.PROP_USERNAME, this.userName);
                    props.put(ContentModel.PROP_FIRSTNAME, this.firstName);
                    props.put(ContentModel.PROP_LASTNAME, this.lastName);
                    if (this.homeSpaceLocation != null && this.homeSpaceName.length() != 0) {
                        homeSpaceNodeRef = this.createHomeSpace(this.homeSpaceLocation.getId(), this.homeSpaceName, true);
                    } else if (this.homeSpaceLocation != null) {
                        homeSpaceNodeRef = this.homeSpaceLocation;
                        this.setupHomeSpacePermissions(homeSpaceNodeRef);
                    } else {
                        homeSpaceNodeRef = this.getCompanyHomeSpace();
                    }
                    props.put(ContentModel.PROP_HOMEFOLDER, (String)homeSpaceNodeRef);
                    props.put(ContentModel.PROP_EMAIL, this.email);
                    props.put(ContentModel.PROP_ORGID, this.companyId);
                    NodeRef newPerson = this.getPersonService().createPerson(props);
                    this.getPermissionService().setPermission(newPerson, this.userName, this.getPermissionService().getAllPermission(), true);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Created Person node for username: " + this.userName));
                    }
                    this.getAuthenticationService().createAuthentication(this.userName, this.password.toCharArray());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Created User Authentication instance for username: " + this.userName));
                    }
                } else {
                    outcome = null;
                    Utils.addErrorMessage(Application.getMessage(context, "error_password_match"));
                }
            }
            tx.commit();
            this.invalidateUserList();
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), ERROR), e.getMessage()), e);
            outcome = null;
        }
        return outcome;
    }

    public String getSummary() {
        String homeSpaceLabel = this.homeSpaceName;
        if (this.homeSpaceName.length() == 0 && this.homeSpaceLocation != null) {
            homeSpaceLabel = Repository.getNameForNode(this.getNodeService(), this.homeSpaceLocation);
        }
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        return this.buildSummary(new String[]{bundle.getString("name"), bundle.getString("username"), bundle.getString("password"), bundle.getString("homespace")}, new String[]{this.firstName + " " + this.lastName, this.userName, "********", homeSpaceLabel});
    }

    public void setupUsers(ActionEvent event) {
        this.invalidateUserList();
    }

    public void startWizardForEdit(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            try {
                NodeRef ref = new NodeRef(Repository.getStoreRef(), id);
                Node node = new Node(ref);
                this.setPerson(node);
                this.editMode = true;
                this.init();
                this.populate();
                this.invalidateUserList();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Started wizard : " + this.getWizardTitle() + " for editing"));
                }
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
            }
        } else {
            this.setPerson(null);
        }
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public NodeRef getHomeSpaceLocation() {
        return this.homeSpaceLocation;
    }

    public void setHomeSpaceLocation(NodeRef homeSpaceLocation) {
        this.homeSpaceLocation = homeSpaceLocation;
    }

    public String getHomeSpaceName() {
        return this.homeSpaceName;
    }

    public void setHomeSpaceName(String homeSpaceName) {
        this.homeSpaceName = homeSpaceName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        if (userName != null) {
            userName = userName.trim();
        }
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public Node getPerson() {
        return this.person;
    }

    public void setPerson(Node person) {
        this.person = person;
    }

    public boolean getEditMode() {
        return this.editMode;
    }

    public void validatePassword(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String pass = (String)value;
        if (pass.length() < 5 || pass.length() > 12) {
            String err = "Password must be between 5 and 12 characters in length.";
            throw new ValidatorException(new FacesMessage(err));
        }
        for (int i = 0; i < pass.length(); ++i) {
            if (Character.isLetterOrDigit(pass.charAt(i))) continue;
            String err = "Password can only contain characters or digits.";
            throw new ValidatorException(new FacesMessage(err));
        }
    }

    public void validateUsername(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String pass = (String)value;
        if (pass.length() < 5 || pass.length() > 12) {
            String err = "Username must be between 5 and 12 characters in length.";
            throw new ValidatorException(new FacesMessage(err));
        }
        for (int i = 0; i < pass.length(); ++i) {
            if (Character.isLetterOrDigit(pass.charAt(i))) continue;
            String err = "Username can only contain characters or digits.";
            throw new ValidatorException(new FacesMessage(err));
        }
    }

    public void validateEmail(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        EmailValidator emailValidator = EmailValidator.getInstance();
        if (!emailValidator.isValid((String)value)) {
            String err = Application.getMessage(context, MSG_ERROR_MAIL_NOT_VALID);
            throw new ValidatorException(new FacesMessage(err));
        }
    }

    private NodeRef getCompanyHomeSpace() {
        if (this.companyHomeSpaceRef == null) {
            this.companyHomeSpaceRef = Repository.getCompanyRoot(FacesContext.getCurrentInstance());
        }
        return this.companyHomeSpaceRef;
    }

    private NodeRef getDefaultHomeSpace() {
        if (this.defaultHomeSpaceRef == null || !this.getNodeService().exists(this.defaultHomeSpaceRef)) {
            String defaultHomeSpacePath = Application.getClientConfig(FacesContext.getCurrentInstance()).getDefaultHomeSpacePath();
            NodeRef rootNodeRef = this.getNodeService().getRootNode(Repository.getStoreRef());
            List nodes = this.getSearchService().selectNodes(rootNodeRef, defaultHomeSpacePath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            if (nodes.size() == 0) {
                return this.getCompanyHomeSpace();
            }
            this.defaultHomeSpaceRef = (NodeRef)nodes.get(0);
        }
        return this.defaultHomeSpaceRef;
    }

    private NodeRef createHomeSpace(String locationId, String spaceName, boolean error) {
        NodeRef homeSpaceNodeRef = null;
        if (spaceName != null && spaceName.length() != 0) {
            NodeRef parentRef = new NodeRef(Repository.getStoreRef(), locationId);
            List children = this.getNodeService().getChildAssocs(parentRef);
            for (ChildAssociationRef ref : children) {
                String childNodeName = (String)((Object)this.getNodeService().getProperty(ref.getChildRef(), ContentModel.PROP_NAME));
                if (!spaceName.equals(childNodeName)) continue;
                if (error) {
                    throw new AlfrescoRuntimeException("A Home Space with the same name already exists.");
                }
                return ref.getChildRef();
            }
            String qname = QName.createValidLocalName((String)spaceName);
            ChildAssociationRef assocRef = this.getNodeService().createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)qname), ContentModel.TYPE_FOLDER);
            NodeRef nodeRef = assocRef.getChildRef();
            this.getNodeService().setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)spaceName));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created Home Space for with name: " + spaceName));
            }
            HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(3);
            uiFacetsProps.put(ApplicationModel.PROP_ICON, "space-icon-default");
            uiFacetsProps.put(ContentModel.PROP_TITLE, spaceName);
            this.getNodeService().addAspect(nodeRef, ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
            this.setupHomeSpacePermissions(nodeRef);
            homeSpaceNodeRef = nodeRef;
        }
        return homeSpaceNodeRef;
    }

    private void setupHomeSpacePermissions(NodeRef homeSpaceRef) {
        this.getPermissionService().setPermission(homeSpaceRef, this.userName, this.getPermissionService().getAllPermission(), true);
        String permission = this.getDefaultPermission();
        if (permission != null && permission.length() != 0) {
            this.getPermissionService().setPermission(homeSpaceRef, this.getPermissionService().getAllAuthorities(), permission, true);
        }
        this.getOwnableService().setOwner(homeSpaceRef, this.userName);
        this.getPermissionService().setPermission(homeSpaceRef, this.getPermissionService().getOwnerAuthority(), this.getPermissionService().getAllPermission(), true);
        this.getPermissionService().setInheritParentPermissions(homeSpaceRef, false);
    }

    private String getDefaultPermission() {
        ClientConfigElement config = Application.getClientConfig(FacesContext.getCurrentInstance());
        return config.getHomeSpacePermission();
    }

    private void invalidateUserList() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
    }
}

